/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb.jboss;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Collections;
import org.jboss.metadata.annotation.creator.AbstractCreator;
import org.jboss.metadata.annotation.creator.AbstractProcessor;
import org.jboss.metadata.annotation.creator.AnnotationContext;
import org.jboss.metadata.annotation.creator.Creator;
import org.jboss.metadata.annotation.creator.ejb.jboss.AbstractSessionBeanProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.ApplicationExceptionProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.JBossConsumerProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.JBossServiceProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.MessageDrivenProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.StatefulProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.StatelessProcessor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.jboss.JBoss50MetaData;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.metadata.ejb.spec.SessionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBoss50Creator
extends AbstractCreator<JBossMetaData>
implements Creator<Collection<Class<?>>, JBoss50MetaData> {
    private EjbJarMetaData ejbJarMetaData;
    private ClassLoader classLoader;

    public JBoss50Creator(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
        this.addProcessor(new StatefulProcessor(finder));
        this.addProcessor(new StatelessProcessor(finder));
        this.addProcessor(new JBossServiceProcessor(finder));
        this.addProcessor(new JBossConsumerProcessor(finder));
        this.addProcessor(new MessageDrivenProcessor(finder));
        this.addProcessor(new ApplicationExceptionProcessor(finder));
    }

    public JBoss50Creator(EjbJarMetaData metaData, ClassLoader classLoader, AnnotationFinder<AnnotatedElement> finder) {
        this(finder);
        this.ejbJarMetaData = metaData;
        this.classLoader = classLoader;
    }

    @Override
    public JBoss50MetaData create(Collection<Class<?>> classes) {
        if ((classes == null || classes.isEmpty()) && (this.ejbJarMetaData == null || this.ejbJarMetaData.getEnterpriseBeans() == null || this.ejbJarMetaData.getEnterpriseBeans().isEmpty())) {
            return null;
        }
        JBoss50MetaData metaData = this.create();
        this.processClassesWithoutTopLevelAnnotations(metaData, classes);
        this.processMetaData(classes, metaData);
        return metaData;
    }

    protected JBoss50MetaData create() {
        JBoss50MetaData metaData = new JBoss50MetaData();
        metaData.setVersion("3.0");
        metaData.setEjbVersion("3.0");
        return metaData;
    }

    private void processClassesWithoutTopLevelAnnotations(JBossMetaData metaData, Collection<Class<?>> classes) {
        if (this.ejbJarMetaData == null || this.classLoader == null) {
            return;
        }
        if (this.ejbJarMetaData.getEnterpriseBeans() == null) {
            return;
        }
        for (EnterpriseBeanMetaData bean : this.ejbJarMetaData.getEnterpriseBeans()) {
            if (bean.getEjbName() == null || bean.getEjbClass() == null || this.containsClass(classes, bean.getEjbClass())) continue;
            try {
                Class<?> ejbClass = this.classLoader.loadClass(bean.getEjbClass());
                if (bean.isSession()) {
                    AbstractSessionBeanProcessor processor;
                    SessionBeanMetaData sb = (SessionBeanMetaData)bean;
                    JBossSessionBeanMetaData sessionBean = new JBossSessionBeanMetaData();
                    sessionBean.setEjbName(sb.getEjbName());
                    sessionBean.setEjbClass(sb.getEjbClass());
                    if (sb.isStateful()) {
                        processor = new StatefulProcessor(this.finder);
                        sessionBean.setSessionType(SessionType.Stateful);
                        processor.process(metaData, sessionBean, ejbClass);
                    } else {
                        processor = new StatelessProcessor(this.finder);
                        sessionBean.setSessionType(SessionType.Stateless);
                        processor.process(metaData, sessionBean, ejbClass);
                    }
                    metaData.getEnterpriseBeans().add(sessionBean);
                    continue;
                }
                if (!bean.isMessageDriven()) continue;
                JBossMessageDrivenBeanMetaData messageDriven = new JBossMessageDrivenBeanMetaData();
                messageDriven.setEjbClass(bean.getEjbClass());
                messageDriven.setEjbName(bean.getEjbName());
                MessageDrivenProcessor processor = new MessageDrivenProcessor(this.finder);
                processor.process(metaData, messageDriven, ejbClass);
                metaData.getEnterpriseBeans().add(messageDriven);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("could not find class: " + bean.getEjbClass(), e);
            }
        }
    }

    @Override
    protected boolean validateClass(Class<?> clazz) {
        return true;
    }

    @Override
    public AnnotationContext getAnnotationContext() {
        return new AnnotationContext(){

            @Override
            public Collection<Class<? extends Annotation>> getTypeAnnotations() {
                return JBoss50Creator.this.getAnnotationsForScope(AbstractProcessor.Scope.TYPE);
            }

            @Override
            public Collection<Class<? extends Annotation>> getFieldAnnotations() {
                return Collections.EMPTY_SET;
            }

            @Override
            public Collection<Class<? extends Annotation>> getMethodAnnotations() {
                return Collections.EMPTY_SET;
            }
        };
    }

    private boolean containsClass(Collection<Class<?>> classes, String className) {
        if (className == null) {
            throw new IllegalArgumentException("null class name.");
        }
        if (classes == null || classes.isEmpty()) {
            return false;
        }
        for (Class<?> clazz : classes) {
            if (!clazz.getName().equals(className)) continue;
            return true;
        }
        return false;
    }
}

