/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.metadata.ejb.jboss;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;

import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;

import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.BasicJndiBindingPolicy;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DeploymentSummary;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.EjbDeploymentSummary;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.KnownInterfaces;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.KnownInterfaces.KnownInterfaceType;
import org.jboss.metadata.ejb.spec.AroundInvokesMetaData;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.metadata.ejb.spec.ContainerTransactionsMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.ExcludeListMetaData;
import org.jboss.metadata.ejb.spec.InitMethodsMetaData;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.metadata.ejb.spec.MethodPermissionsMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.RemoveMethodsMetaData;
import org.jboss.metadata.ejb.spec.SecurityIdentityMetaData;
import org.jboss.metadata.ejb.spec.SessionType;
import org.jboss.metadata.javaee.jboss.AnnotationsMetaData;
import org.jboss.metadata.javaee.jboss.IgnoreDependencyMetaData;
import org.jboss.metadata.javaee.jboss.JndiRefsMetaData;
import org.jboss.metadata.javaee.spec.AnnotatedEJBReferencesMetaData;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.EJBLocalReferenceMetaData;
import org.jboss.metadata.javaee.spec.EJBLocalReferencesMetaData;
import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.EJBReferencesMetaData;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
import org.jboss.metadata.javaee.spec.PersistenceContextReferenceMetaData;
import org.jboss.metadata.javaee.spec.PersistenceContextReferencesMetaData;
import org.jboss.metadata.javaee.spec.PersistenceUnitReferenceMetaData;
import org.jboss.metadata.javaee.spec.PersistenceUnitReferencesMetaData;
import org.jboss.metadata.javaee.spec.PortComponent;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferencesMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;
import org.jboss.metadata.javaee.support.IdMetaData;
import org.jboss.metadata.javaee.support.IdMetaDataImpl;
import org.jboss.metadata.javaee.support.NamedMetaData;

/**
 * Decorate a JBossSessionBeanMetaData with JNDI policy, so any getter of a JNDI
 * name will never return null.
 * 
 * Note that you should on call getters on this object.
 * 
 * @author <a href="mailto:carlo.dewolf@jboss.com">Carlo de Wolf</a>
 * @version $Revision: $
 */
public class JBossSessionPolicyDecorator extends JBossSessionBeanMetaData
{
   private static final long serialVersionUID = 1L;

   private JBossSessionBeanMetaData delegate;

   public JBossSessionPolicyDecorator(JBossSessionBeanMetaData delegate)
   {
      assert delegate != null : "delegate is null";
      
      this.delegate = delegate;
   }
   
   protected KnownInterfaceType classifyInterface(String iface)
   {
      KnownInterfaceType ifaceType = KnownInterfaces.classifyInterface(iface);
      if(ifaceType != KnownInterfaceType.UNKNOWN)
         return ifaceType;
      
      // Need to compare iface against the metadata local-home/home & business locals/remotes
      // Figure out the interface type from the metadata
      if (delegate.getLocalHome() != null && delegate.getLocalHome().equals(iface))
         return KnownInterfaceType.LOCAL_HOME;
      else if (delegate.getHome() != null && delegate.getHome().equals(iface))
         return KnownInterfaceType.REMOTE_HOME;
      else
      {
         // Check business locals
         BusinessLocalsMetaData locals = delegate.getBusinessLocals();
         if (locals != null)
         {
            for (String local : locals)
            {
               if (local.equals(iface))
               {
                  return KnownInterfaceType.BUSINESS_LOCAL;
               }
            }
         }
         if (ifaceType == KnownInterfaceType.UNKNOWN)
         {
            // Check business remotes
            BusinessRemotesMetaData remotes = delegate.getBusinessRemotes();
            if (remotes != null)
            {
               for (String remote : remotes)
               {
                  if (remote.equals(iface))
                  {
                     return KnownInterfaceType.BUSINESS_REMOTE;
                  }
               }
            }
         }
      }
      
      throw new IllegalArgumentException("Can't find interface " + iface + " in " + this);
   }
   
   private EjbDeploymentSummary getEjbDeploymentSummary()
   {
      DeploymentSummary dsummary = getJBossMetaData().getDeploymentSummary();
      if(dsummary == null)
         dsummary = new DeploymentSummary();
      return new EjbDeploymentSummary(delegate, dsummary);
   }
   
   
   private DefaultJndiBindingPolicy getDefaultJndiBindingPolicy()
   {
      return getDefaultJndiBindingPolicy(null);
   }
   
   /**
    * Resolve the JNDI binding policy that's to be used.
    * 
    * Slow method.
    * 
    * @return the JNDI binding policy to be used
    */
   private DefaultJndiBindingPolicy getDefaultJndiBindingPolicy(DefaultJndiBindingPolicy defaultPolicy)
   {
      String baseName = delegate.getMappedName();
      if(baseName == null)
         baseName = delegate.determineJndiName();
      
      // Obtain the Deployment Summary
      DeploymentSummary dsummary = getJBossMetaData().getDeploymentSummary();
      
      // Initialize the Default JNDI Binding Policy
      DefaultJndiBindingPolicy policy = null;
      
      // If Deployment Summary is defined
      if (dsummary != null)
      {
         try
         {
            // Create a JNDI Policy from the Deployment Summary
            policy = createPolicy(dsummary.getLoader(), null);
         }
         catch (Exception e)
         {
         }
      }
      if (policy == null)
         policy = defaultPolicy;
      if (policy == null)
      {
         // Use the metadata default binding policy
         policy = new BasicJndiBindingPolicy(baseName);
      }
      
      return policy;
   }

   @Deprecated
   public String determineJndiName()
   {
      return getJndiName();
   }

   @Deprecated
   public String determineLocalJndiName()
   {
      return getLocalJndiName();
   }

   public String determineResolvedJndiName(String iface, DefaultJndiBindingPolicy defaultPolicy)
   {
      DefaultJndiBindingPolicy policy = getDefaultJndiBindingPolicy(defaultPolicy);
      
      KnownInterfaceType ifaceType = classifyInterface(iface);

      // Have the policy generate the actual name
      String resolvedJndiName = policy.getJndiName(getEjbDeploymentSummary(), iface, ifaceType);

      return resolvedJndiName;
   }

   public String determineResolvedJndiName(String iface)
   {
      return determineResolvedJndiName(iface, null);
   }
   
   public String getHomeJndiName()
   {
      String s = delegate.getHomeJndiName();
      if(s != null)
         return s;
      
      return getDefaultJndiBindingPolicy().getJndiName(getEjbDeploymentSummary(), null, KnownInterfaceType.REMOTE_HOME);
   }
   
   public String getJndiName()
   {
      String s = delegate.getJndiName();
      if(s != null)
         return s;
      
      // TODO: This is a bit of trickery, because it is beyond the responsibility of this class
      return getMappedName();
   }
   
   public String getLocalHomeJndiName()
   {
      String s = delegate.getLocalHomeJndiName();
      if(s != null)
         return s;
      
      return getDefaultJndiBindingPolicy().getJndiName(getEjbDeploymentSummary(), null, KnownInterfaceType.LOCAL_HOME);
   }
   
   public String getLocalJndiName()
   {
      String s = delegate.getLocalJndiName();
      if(s != null)
         return s;
      
      return getDefaultJndiBindingPolicy().getJndiName(getEjbDeploymentSummary(), null, KnownInterfaceType.BUSINESS_LOCAL);
   }
   
   public String getMappedName()
   {
      String s = delegate.getMappedName();
      if(s != null)
         return s;
      
      return getDefaultJndiBindingPolicy().getJndiName(getEjbDeploymentSummary(), null, KnownInterfaceType.BUSINESS_REMOTE);
   }
   
   
   /* Only delegation beyond this point */
   
   public void checkValid()
   {
      delegate.checkValid();
   }

   public IdMetaDataImpl clone()
   {
      throw new RuntimeException("NYI");
   }

   public DefaultJndiBindingPolicy createPolicy(ClassLoader loader,
         Class<? extends DefaultJndiBindingPolicy> defaultPolicyClass) throws Exception
   {
      return delegate.createPolicy(loader, defaultPolicyClass);
   }

   public Set<String> determineAllDepends()
   {
      return delegate.determineAllDepends();
   }

   public ClusterConfigMetaData determineClusterConfig()
   {
      return delegate.determineClusterConfig();
   }

   public String determineConfigurationName()
   {
      return delegate.determineConfigurationName();
   }

   public ContainerConfigurationMetaData determineContainerConfiguration()
   {
      return delegate.determineContainerConfiguration();
   }

   public String determineContainerName()
   {
      return delegate.determineContainerName();
   }

   public InvokerBindingMetaData determineInvokerBinding(String invokerName)
   {
      return delegate.determineInvokerBinding(invokerName);
   }

   public InvokerBindingsMetaData determineInvokerBindings()
   {
      return delegate.determineInvokerBindings();
   }

   public boolean equals(Object obj)
   {
      return delegate.equals(obj);
   }

   public AnnotatedEJBReferencesMetaData getAnnotatedEjbReferences()
   {
      return delegate.getAnnotatedEjbReferences();
   }

   public AnnotationsMetaData getAnnotations()
   {
      return delegate.getAnnotations();
   }

   public String getAopDomainName()
   {
      return delegate.getAopDomainName();
   }

   public AroundInvokesMetaData getAroundInvokes()
   {
      return delegate.getAroundInvokes();
   }

   public BusinessLocalsMetaData getBusinessLocals()
   {
      return delegate.getBusinessLocals();
   }

   public BusinessRemotesMetaData getBusinessRemotes()
   {
      return delegate.getBusinessRemotes();
   }

   public CacheConfigMetaData getCacheConfig()
   {
      return delegate.getCacheConfig();
   }

   public ClusterConfigMetaData getClusterConfig()
   {
      return delegate.getClusterConfig();
   }

   public String getConfigurationName()
   {
      return delegate.getConfigurationName();
   }

   public String getContainerName()
   {
      return delegate.getContainerName();
   }

   public String getContainerObjectNameJndiName()
   {
      return delegate.getContainerObjectNameJndiName();
   }

   public ContainerTransactionsMetaData getContainerTransactions()
   {
      return delegate.getContainerTransactions();
   }

   public String getDefaultConfigurationName()
   {
      return delegate.getDefaultConfigurationName();
   }

   public String getDefaultInvokerName()
   {
      return delegate.getDefaultInvokerName();
   }

   public Set<String> getDepends()
   {
      return delegate.getDepends();
   }

   public DescriptionGroupMetaData getDescriptionGroup()
   {
      return delegate.getDescriptionGroup();
   }

   public String getEjbClass()
   {
      return delegate.getEjbClass();
   }

   public JBossMetaData getEjbJarMetaData()
   {
      return delegate.getEjbJarMetaData();
   }

   public EJBLocalReferenceMetaData getEjbLocalReferenceByName(String name)
   {
      return delegate.getEjbLocalReferenceByName(name);
   }

   public EJBLocalReferencesMetaData getEjbLocalReferences()
   {
      return delegate.getEjbLocalReferences();
   }

   public String getEjbName()
   {
      return delegate.getEjbName();
   }

   public EJBReferenceMetaData getEjbReferenceByName(String name)
   {
      return delegate.getEjbReferenceByName(name);
   }

   public EJBReferencesMetaData getEjbReferences()
   {
      return delegate.getEjbReferences();
   }

   public SecurityIdentityMetaData getEjbTimeoutIdentity()
   {
      return delegate.getEjbTimeoutIdentity();
   }

   public JBossEnterpriseBeansMetaData getEnterpriseBeansMetaData()
   {
      return delegate.getEnterpriseBeansMetaData();
   }

   public EnvironmentEntriesMetaData getEnvironmentEntries()
   {
      return delegate.getEnvironmentEntries();
   }

   public EnvironmentEntryMetaData getEnvironmentEntryByName(String name)
   {
      return delegate.getEnvironmentEntryByName(name);
   }

   public ExcludeListMetaData getExcludeList()
   {
      return delegate.getExcludeList();
   }

   public String getGeneratedContainerName()
   {
      return delegate.getGeneratedContainerName();
   }

   public String getHome()
   {
      return delegate.getHome();
   }

   public String getId()
   {
      return delegate.getId();
   }

   public IgnoreDependencyMetaData getIgnoreDependency()
   {
      return delegate.getIgnoreDependency();
   }

   public InitMethodsMetaData getInitMethods()
   {
      return delegate.getInitMethods();
   }

   public InvokerBindingsMetaData getInvokerBindings()
   {
      return delegate.getInvokerBindings();
   }

   public IORSecurityConfigMetaData getIorSecurityConfig()
   {
      return delegate.getIorSecurityConfig();
   }

   public JBossMetaData getJBossMetaData()
   {
      return delegate.getJBossMetaData();
   }

   public JBossMetaData getJBossMetaDataWithCheck()
   {
      return delegate.getJBossMetaDataWithCheck();
   }

   public String getJndiBindingPolicy()
   {
      return delegate.getJndiBindingPolicy();
   }

   public Environment getJndiEnvironmentRefsGroup()
   {
      return delegate.getJndiEnvironmentRefsGroup();
   }

   public JndiRefsMetaData getJndiRefs()
   {
      return delegate.getJndiRefs();
   }

   public String getKey()
   {
      return delegate.getKey();
   }

   public String getLocal()
   {
      return delegate.getLocal();
   }

   public String getLocalHome()
   {
      return delegate.getLocalHome();
   }

   public MessageDestinationReferenceMetaData getMessageDestinationReferenceByName(String name)
   {
      return delegate.getMessageDestinationReferenceByName(name);
   }

   public MessageDestinationReferencesMetaData getMessageDestinationReferences()
   {
      return delegate.getMessageDestinationReferences();
   }

   public MethodAttributesMetaData getMethodAttributes()
   {
      return delegate.getMethodAttributes();
   }

   public MethodPermissionsMetaData getMethodPermissions()
   {
      return delegate.getMethodPermissions();
   }

   public Set<String> getMethodPermissions(String methodName, Class<?>[] params, MethodInterfaceType interfaceType)
   {
      return delegate.getMethodPermissions(methodName, params, interfaceType);
   }

   public int getMethodTransactionTimeout(Method method)
   {
      return delegate.getMethodTransactionTimeout(method);
   }

   public int getMethodTransactionTimeout(String methodName)
   {
      return delegate.getMethodTransactionTimeout(methodName);
   }

   public TransactionAttributeType getMethodTransactionType(Method m, MethodInterfaceType iface)
   {
      return delegate.getMethodTransactionType(m, iface);
   }

   public TransactionAttributeType getMethodTransactionType(String methodName, Class<?>[] params,
         MethodInterfaceType iface)
   {
      return delegate.getMethodTransactionType(methodName, params, iface);
   }

   public String getName()
   {
      return delegate.getName();
   }

   public PersistenceContextReferenceMetaData getPersistenceContextReferenceByName(String name)
   {
      return delegate.getPersistenceContextReferenceByName(name);
   }

   public PersistenceContextReferencesMetaData getPersistenceContextRefs()
   {
      return delegate.getPersistenceContextRefs();
   }

   public PersistenceUnitReferenceMetaData getPersistenceUnitReferenceByName(String name)
   {
      return delegate.getPersistenceUnitReferenceByName(name);
   }

   public PersistenceUnitReferencesMetaData getPersistenceUnitRefs()
   {
      return delegate.getPersistenceUnitRefs();
   }

   public PoolConfigMetaData getPoolConfig()
   {
      return delegate.getPoolConfig();
   }

   public PortComponent getPortComponent()
   {
      return delegate.getPortComponent();
   }

   public LifecycleCallbacksMetaData getPostActivates()
   {
      return delegate.getPostActivates();
   }

   public LifecycleCallbacksMetaData getPostConstructs()
   {
      return delegate.getPostConstructs();
   }

   public LifecycleCallbacksMetaData getPreDestroys()
   {
      return delegate.getPreDestroys();
   }

   public LifecycleCallbacksMetaData getPrePassivates()
   {
      return delegate.getPrePassivates();
   }

   public String getRemote()
   {
      return delegate.getRemote();
   }

   public List<RemoteBindingMetaData> getRemoteBindings()
   {
      return delegate.getRemoteBindings();
   }

   public RemoveMethodsMetaData getRemoveMethods()
   {
      return delegate.getRemoveMethods();
   }

   public ResourceEnvironmentReferenceMetaData getResourceEnvironmentReferenceByName(String name)
   {
      return delegate.getResourceEnvironmentReferenceByName(name);
   }

   public ResourceEnvironmentReferencesMetaData getResourceEnvironmentReferences()
   {
      return delegate.getResourceEnvironmentReferences();
   }

   public ResourceReferenceMetaData getResourceReferenceByName(String name)
   {
      return delegate.getResourceReferenceByName(name);
   }

   public ResourceReferencesMetaData getResourceReferences()
   {
      return delegate.getResourceReferences();
   }

   public String getSecurityDomain()
   {
      return delegate.getSecurityDomain();
   }

   public SecurityIdentityMetaData getSecurityIdentity()
   {
      return delegate.getSecurityIdentity();
   }

   public String getSecurityProxy()
   {
      return delegate.getSecurityProxy();
   }

   public SecurityRoleMetaData getSecurityRole(String roleName)
   {
      return delegate.getSecurityRole(roleName);
   }

   public Set<String> getSecurityRolePrincipals(String roleName)
   {
      return delegate.getSecurityRolePrincipals(roleName);
   }

   public SecurityRoleRefsMetaData getSecurityRoleRefs()
   {
      return delegate.getSecurityRoleRefs();
   }

   public String getServiceEndpoint()
   {
      return delegate.getServiceEndpoint();
   }

   public ServiceReferenceMetaData getServiceReferenceByName(String name)
   {
      return delegate.getServiceReferenceByName(name);
   }

   public ServiceReferencesMetaData getServiceReferences()
   {
      return delegate.getServiceReferences();
   }

   public SessionType getSessionType()
   {
      return delegate.getSessionType();
   }

   public NamedMethodMetaData getTimeoutMethod()
   {
      return delegate.getTimeoutMethod();
   }

   public TransactionManagementType getTransactionType()
   {
      return delegate.getTransactionType();
   }

   public int hashCode()
   {
      return delegate.hashCode();
   }

   public boolean hasMethodPermissions(String methodName, Class<?>[] params, MethodInterfaceType interfaceType)
   {
      return delegate.hasMethodPermissions(methodName, params, interfaceType);
   }

   public boolean isBMT()
   {
      return delegate.isBMT();
   }

   public boolean isCallByValue()
   {
      return delegate.isCallByValue();
   }

   public boolean isClustered()
   {
      return delegate.isClustered();
   }

   public boolean isCMT()
   {
      return delegate.isCMT();
   }

   public Boolean isConcurrent()
   {
      return delegate.isConcurrent();
   }

   public boolean isConsumer()
   {
      return delegate.isConsumer();
   }

   public boolean isEntity()
   {
      return delegate.isEntity();
   }

   public boolean isExceptionOnRollback()
   {
      return delegate.isExceptionOnRollback();
   }

   public boolean isMessageDriven()
   {
      return delegate.isMessageDriven();
   }

   public boolean isMethodReadOnly(Method method)
   {
      return delegate.isMethodReadOnly(method);
   }

   public boolean isMethodReadOnly(String methodName)
   {
      return delegate.isMethodReadOnly(methodName);
   }

   public boolean isService()
   {
      return delegate.isService();
   }

   public boolean isSession()
   {
      return delegate.isSession();
   }

   public boolean isStateful()
   {
      return delegate.isStateful();
   }

   public boolean isStateless()
   {
      return delegate.isStateless();
   }

   public boolean isTimerPersistence()
   {
      return delegate.isTimerPersistence();
   }

   public void merge(IdMetaData override, IdMetaData original)
   {
      delegate.merge(override, original);
   }

   public void merge(IdMetaDataImpl override, IdMetaDataImpl original)
   {
      delegate.merge(override, original);
   }

   public void merge(JBossEnterpriseBeanMetaData override, EnterpriseBeanMetaData original, String overridenFile,
         String overrideFile, boolean mustOverride)
   {
      delegate.merge(override, original, overridenFile, overrideFile, mustOverride);
   }

   public void merge(JBossEnterpriseBeanMetaData override, EnterpriseBeanMetaData original)
   {
      delegate.merge(override, original);
   }

   public void merge(NamedMetaData override, NamedMetaData original)
   {
      delegate.merge(override, original);
   }

   public void setAnnotations(AnnotationsMetaData annotations)
   {
      delegate.setAnnotations(annotations);
   }

   public void setAopDomainName(String aopDomainName)
   {
      delegate.setAopDomainName(aopDomainName);
   }

   public void setAroundInvokes(AroundInvokesMetaData aroundInvokes)
   {
      delegate.setAroundInvokes(aroundInvokes);
   }

   public void setBusinessLocals(BusinessLocalsMetaData businessLocals)
   {
      delegate.setBusinessLocals(businessLocals);
   }

   public void setBusinessRemotes(BusinessRemotesMetaData businessRemotes)
   {
      delegate.setBusinessRemotes(businessRemotes);
   }

   public void setCacheConfig(CacheConfigMetaData cacheConfig)
   {
      delegate.setCacheConfig(cacheConfig);
   }

   public void setCallByValue(boolean callByValue)
   {
      delegate.setCallByValue(callByValue);
   }

   public void setClusterConfig(ClusterConfigMetaData clusterConfig)
   {
      delegate.setClusterConfig(clusterConfig);
   }

   public void setClustered(boolean clustered)
   {
      delegate.setClustered(clustered);
   }

   public void setConcurrent(Boolean concurrent)
   {
      delegate.setConcurrent(concurrent);
   }

   public void setConfigurationName(String configurationName)
   {
      delegate.setConfigurationName(configurationName);
   }

   public void setContainerName(String containerName)
   {
      delegate.setContainerName(containerName);
   }

   public void setDepends(Set<String> depends)
   {
      delegate.setDepends(depends);
   }

   public void setDescriptionGroup(DescriptionGroupMetaData descriptionGroup)
   {
      delegate.setDescriptionGroup(descriptionGroup);
   }

   public void setEjbClass(String ejbClass)
   {
      delegate.setEjbClass(ejbClass);
   }

   public void setEjbName(String ejbName)
   {
      delegate.setEjbName(ejbName);
   }

   public void setEjbTimeoutIdentity(SecurityIdentityMetaData ejbTimeoutIdentity)
   {
      delegate.setEjbTimeoutIdentity(ejbTimeoutIdentity);
   }

   public void setEnterpriseBeansMetaData(JBossEnterpriseBeansMetaData enterpriseBeansMetaData)
   {
      delegate.setEnterpriseBeansMetaData(enterpriseBeansMetaData);
   }

   public void setExceptionOnRollback(boolean exceptionOnRollback)
   {
      delegate.setExceptionOnRollback(exceptionOnRollback);
   }

   public void setGeneratedContainerName(String containerName)
   {
      delegate.setGeneratedContainerName(containerName);
   }

   public void setHome(String home)
   {
      delegate.setHome(home);
   }

   public void setHomeJndiName(String homeJndiName)
   {
      delegate.setHomeJndiName(homeJndiName);
   }

   public void setId(String id)
   {
      delegate.setId(id);
   }

   public void setIgnoreDependency(IgnoreDependencyMetaData ignoreDependency)
   {
      delegate.setIgnoreDependency(ignoreDependency);
   }

   public void setInitMethods(InitMethodsMetaData initMethods)
   {
      delegate.setInitMethods(initMethods);
   }

   public void setInvokerBindings(InvokerBindingsMetaData invokers)
   {
      delegate.setInvokerBindings(invokers);
   }

   public void setIorSecurityConfig(IORSecurityConfigMetaData iorSecurityConfig)
   {
      delegate.setIorSecurityConfig(iorSecurityConfig);
   }

   public void setJndiBindingPolicy(String jndiBindingPolicy)
   {
      delegate.setJndiBindingPolicy(jndiBindingPolicy);
   }

   public void setJndiEnvironmentRefsGroup(Environment env)
   {
      delegate.setJndiEnvironmentRefsGroup(env);
   }

   public void setJndiName(String jndiName)
   {
      delegate.setJndiName(jndiName);
   }

   public void setJndiRefs(JndiRefsMetaData jndiRefs)
   {
      delegate.setJndiRefs(jndiRefs);
   }

   public void setLocal(String local)
   {
      delegate.setLocal(local);
   }

   public void setLocalHome(String localHome)
   {
      delegate.setLocalHome(localHome);
   }

   public void setLocalHomeJndiName(String localHomeJndiName)
   {
      delegate.setLocalHomeJndiName(localHomeJndiName);
   }

   public void setLocalJndiName(String localJndiName)
   {
      delegate.setLocalJndiName(localJndiName);
   }

   public void setMappedName(String mappedName)
   {
      delegate.setMappedName(mappedName);
   }

   public void setMethodAttributes(MethodAttributesMetaData methodAttributes)
   {
      delegate.setMethodAttributes(methodAttributes);
   }

   public void setName(String name)
   {
      delegate.setName(name);
   }

   public void setPoolConfig(PoolConfigMetaData poolConfig)
   {
      delegate.setPoolConfig(poolConfig);
   }

   public void setPortComponent(PortComponent portComponent)
   {
      delegate.setPortComponent(portComponent);
   }

   public void setPostActivates(LifecycleCallbacksMetaData postActivates)
   {
      delegate.setPostActivates(postActivates);
   }

   public void setPrePassivates(LifecycleCallbacksMetaData prePassivates)
   {
      delegate.setPrePassivates(prePassivates);
   }

   public void setRemote(String remote)
   {
      delegate.setRemote(remote);
   }

   public void setRemoteBindings(List<RemoteBindingMetaData> remoteBindings)
   {
      delegate.setRemoteBindings(remoteBindings);
   }

   public void setRemoveMethods(RemoveMethodsMetaData removeMethods)
   {
      delegate.setRemoveMethods(removeMethods);
   }

   public void setSecurityDomain(String securityDomain)
   {
      delegate.setSecurityDomain(securityDomain);
   }

   public void setSecurityIdentity(SecurityIdentityMetaData securityIdentity)
   {
      delegate.setSecurityIdentity(securityIdentity);
   }

   public void setSecurityProxy(String securityProxy)
   {
      delegate.setSecurityProxy(securityProxy);
   }

   public void setSecurityRoleRefs(SecurityRoleRefsMetaData securityRoleRefs)
   {
      delegate.setSecurityRoleRefs(securityRoleRefs);
   }

   public void setServiceEndpoint(String serviceEndpoint)
   {
      delegate.setServiceEndpoint(serviceEndpoint);
   }

   public void setSessionType(SessionType sessionType)
   {
      delegate.setSessionType(sessionType);
   }

   public void setTimeoutMethod(NamedMethodMetaData timeoutMethod)
   {
      delegate.setTimeoutMethod(timeoutMethod);
   }

   public void setTimerPersistence(boolean timerPersistence)
   {
      delegate.setTimerPersistence(timerPersistence);
   }

   public void setTransactionType(TransactionManagementType transactionType)
   {
      delegate.setTransactionType(transactionType);
   }
   
   
}
