/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.metadata.annotation.creator.ejb.jboss;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Creator;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.jboss.JBoss50MetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;


/**
 * A JBoss50Creator.
 * 
 * @author <a href="alex@jboss.com">Alexey Loubyansky</a>
 * @version $Revision: 1.1 $
 */
public class JBoss50Creator extends AbstractFinderUser
   implements Creator<Collection<Class<?>>, JBoss50MetaData>
{
   private List<Processor<JBossMetaData, Class<?>>> processors;

   public JBoss50Creator(AnnotationFinder<AnnotatedElement> finder)
   {
      super(finder);
      
      processors = new ArrayList<Processor<JBossMetaData,Class<?>>>();
      processors.add(new StatefulProcessor(finder));
      processors.add(new StatelessProcessor(finder));
      processors.add(new MessageDrivenProcessor(finder));
      processors.add(new EntityProcessor(finder));
      processors.add(new ApplicationExceptionProcessor(finder));
   }

   public JBoss50MetaData create(Collection<Class<?>> classes)
   {
      JBoss50MetaData metaData = new JBoss50MetaData();
      metaData.setVersion("3.0");
      metaData.setEjbVersion("3.0");
      
      for(Class<?> cls : classes)
      {
         for(Processor<JBossMetaData, Class<?>> processor : processors)
         {
            processor.process(metaData, cls);
         }
      }

      return metaData;
   }
}
