/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.jboss.jms.wireformat.ClientDelivery;
import org.jboss.jms.wireformat.ConnectionFactoryUpdate;
import org.jboss.jms.wireformat.NullResponse;
import org.jboss.jms.wireformat.PacketSupport;
import org.jboss.jms.wireformat.PolledCallbacksDelivery;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;
import org.jboss.jms.wireformat.SerializedPacket;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.invocation.InternalInvocation;
import org.jboss.remoting.invocation.OnewayInvocation;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;

public class JMSWireFormat
implements Marshaller,
UnMarshaller {
    private static final long serialVersionUID = -7646123424863782043L;
    private static final Logger log = Logger.getLogger(JMSWireFormat.class);
    protected boolean trace = log.isTraceEnabled();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(Object obj, OutputStream out) throws IOException {
        DataOutputStream dos;
        if (this.trace) {
            log.trace((Object)("Writing " + obj));
        }
        if (out instanceof DataOutputStream) {
            dos = (DataOutputStream)out;
            if (this.trace) {
                log.trace((Object)"Stream is a DataOutputStream");
            }
        } else {
            if (out instanceof ObjectOutputStream) {
                throw new IllegalArgumentException("Invalid stream - are you sure you have configured socket wrappers?");
            }
            dos = new DataOutputStream(out);
            if (this.trace) {
                log.trace((Object)"Stream is NOT a DataOutputStream - must be using HTTP transport");
            }
        }
        try {
            PacketSupport packet = null;
            if (obj instanceof InvocationRequest) {
                InvocationRequest req = (InvocationRequest)obj;
                Object param = req.getParameter();
                if (param instanceof PacketSupport) {
                    packet = (PacketSupport)param;
                    if (this.trace) {
                        log.trace((Object)"JBM Request");
                    }
                } else if (param instanceof OnewayInvocation) {
                    OnewayInvocation oneWay;
                    if (this.trace) {
                        log.trace((Object)"It's a OnewayInvocation");
                    }
                    if ((param = (oneWay = (OnewayInvocation)param).getParameters()[0]) instanceof RequestSupport) {
                        if (this.trace) {
                            log.trace((Object)"JBM oneway request");
                        }
                        packet = (PacketSupport)param;
                    } else {
                        if (!(param instanceof InternalInvocation)) throw new IllegalArgumentException("Invalid request param " + param);
                        InternalInvocation ii = (InternalInvocation)param;
                        Object[] params = ii.getParameters();
                        if (this.trace) {
                            log.trace((Object)("Params is " + params));
                        }
                        if (params != null && params.length > 0 && params[0] instanceof Callback) {
                            Callback callback = (Callback)params[0];
                            if (this.trace) {
                                log.trace((Object)("It's a callback: " + callback));
                            }
                            if (callback.getParameter() instanceof ClientDelivery) {
                                packet = (ClientDelivery)callback.getParameter();
                                if (this.trace) {
                                    log.trace((Object)"Message delivery callback");
                                }
                            } else if (callback.getParameter() instanceof ConnectionFactoryUpdate) {
                                packet = (ConnectionFactoryUpdate)callback.getParameter();
                                if (this.trace) {
                                    log.trace((Object)"Connection factory update callback");
                                }
                            }
                        }
                    }
                } else {
                    packet = new SerializedPacket(req);
                }
            } else if (obj instanceof InvocationResponse) {
                InvocationResponse resp = (InvocationResponse)obj;
                Object param = resp.getResult();
                if (param instanceof ResponseSupport) {
                    packet = (ResponseSupport)param;
                    if (this.trace) {
                        log.trace((Object)"JBM Response");
                    }
                } else if (param instanceof List) {
                    packet = new PolledCallbacksDelivery((List)param, resp.getSessionId());
                } else if (param == null) {
                    packet = new NullResponse();
                    if (this.trace) {
                        log.trace((Object)"Null Response");
                    }
                } else {
                    packet = new SerializedPacket(obj);
                }
            } else {
                packet = new SerializedPacket(obj);
            }
            if (this.trace) {
                log.trace((Object)("Writing packet: " + packet));
            }
            packet.write(dos);
            if (!this.trace) return;
            log.trace((Object)"Wrote packet");
            return;
        }
        catch (Exception e) {
            IOException e2 = new IOException(e.getMessage());
            e2.setStackTrace(e.getStackTrace());
            throw e2;
        }
    }

    public Marshaller cloneMarshaller() throws CloneNotSupportedException {
        return this;
    }

    public Object read(InputStream in, Map map) throws IOException, ClassNotFoundException {
        DataInputStream dis;
        if (this.trace) {
            log.trace((Object)"Reading");
        }
        if (in instanceof DataInputStream) {
            dis = (DataInputStream)in;
            if (this.trace) {
                log.trace((Object)"Stream is already DataInputStream :)");
            }
        } else {
            if (in instanceof ObjectInputStream) {
                throw new IllegalArgumentException("Invalid stream - are you sure you have configured socket wrappers?");
            }
            dis = new DataInputStream(in);
            if (this.trace) {
                log.trace((Object)"Stream is NOT DataInputStream - must be using HTTP transport");
            }
        }
        int id = dis.readInt();
        PacketSupport packet = PacketSupport.createPacket(id);
        if (this.trace) {
            log.trace((Object)("Created packet " + packet));
        }
        try {
            if (this.trace) {
                log.trace((Object)"Reading packet");
            }
            packet.read(dis);
            if (this.trace) {
                log.trace((Object)"Read packet");
            }
        }
        catch (Exception e) {
            IOException e2 = new IOException(e.getMessage());
            e2.setStackTrace(e.getStackTrace());
            throw e2;
        }
        Object payload = packet.getPayload();
        if (this.trace) {
            log.trace((Object)("Returning payload: " + payload));
        }
        return payload;
    }

    public UnMarshaller cloneUnMarshaller() throws CloneNotSupportedException {
        return this;
    }

    public void setClassLoader(ClassLoader classloader) {
    }
}

