/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jboss.marshalling.UnmarshallingObjectInputFilter;

final class UnmarshallingObjectInputFilterImpl
implements UnmarshallingObjectInputFilter {
    private final List<Function<UnmarshallingObjectInputFilter.FilterInfo, UnmarshallingObjectInputFilter.Status>> unmarshallingFilters;

    UnmarshallingObjectInputFilterImpl(String filterSpec) {
        if (filterSpec == null) {
            throw new IllegalArgumentException("Parameter 'filterSpec' may not be null");
        }
        ArrayList<String> parsedFilterSpecs = new ArrayList<String>(Arrays.asList(filterSpec.split(";")));
        this.unmarshallingFilters = new ArrayList<Function<UnmarshallingObjectInputFilter.FilterInfo, UnmarshallingObjectInputFilter.Status>>(parsedFilterSpecs.size());
        ExactMatchFilter exactMatchAllowlist = null;
        ExactMatchFilter exactMatchDenylist = null;
        for (String spec : parsedFilterSpecs) {
            Function<UnmarshallingObjectInputFilter.FilterInfo, UnmarshallingObjectInputFilter.Status> filter;
            if (spec.contains("/")) {
                throw UnmarshallingObjectInputFilterImpl.invalidFilterSpec(spec);
            }
            int eqPos = spec.indexOf(61);
            if (eqPos > -1) {
                filter = this.parseLimitSpec(spec, eqPos);
            } else {
                filter = this.parseClassSpec(spec, exactMatchDenylist, exactMatchDenylist);
                if ((exactMatchAllowlist == null || exactMatchDenylist == null) && filter instanceof ExactMatchFilter) {
                    ExactMatchFilter exactMatch = (ExactMatchFilter)filter;
                    if (exactMatch.isForAllowlist()) {
                        exactMatchAllowlist = exactMatch;
                    } else {
                        exactMatchDenylist = exactMatch;
                    }
                }
            }
            if (filter == null) continue;
            this.unmarshallingFilters.add(filter);
        }
        if (this.unmarshallingFilters.size() == 0) {
            throw UnmarshallingObjectInputFilterImpl.invalidFilterSpec(filterSpec);
        }
    }

    private Function<UnmarshallingObjectInputFilter.FilterInfo, UnmarshallingObjectInputFilter.Status> parseLimitSpec(String spec, int eqPos) {
        Function<UnmarshallingObjectInputFilter.FilterInfo, UnmarshallingObjectInputFilter.Status> filter;
        long value;
        String type = spec.substring(0, eqPos);
        if (eqPos == spec.length() - 1) {
            throw UnmarshallingObjectInputFilterImpl.invalidFilterSpec(spec);
        }
        try {
            value = Long.parseLong(spec.substring(eqPos + 1));
        }
        catch (NumberFormatException e) {
            throw UnmarshallingObjectInputFilterImpl.invalidFilterSpec(spec, e);
        }
        if (value < 0L) {
            throw UnmarshallingObjectInputFilterImpl.invalidFilterSpec(spec);
        }
        switch (type) {
            case "maxdepth": {
                filter = filterInfo -> filterInfo.getDepth() > value ? UnmarshallingObjectInputFilter.Status.REJECTED : UnmarshallingObjectInputFilter.Status.UNDECIDED;
                break;
            }
            case "maxarray": {
                filter = filterInfo -> filterInfo.getArrayLength() > value ? UnmarshallingObjectInputFilter.Status.REJECTED : UnmarshallingObjectInputFilter.Status.UNDECIDED;
                break;
            }
            case "maxrefs": {
                filter = filterInfo -> filterInfo.getReferences() > value ? UnmarshallingObjectInputFilter.Status.REJECTED : UnmarshallingObjectInputFilter.Status.UNDECIDED;
                break;
            }
            case "maxbytes": {
                filter = filterInfo -> filterInfo.getStreamBytes() > value ? UnmarshallingObjectInputFilter.Status.REJECTED : UnmarshallingObjectInputFilter.Status.UNDECIDED;
                break;
            }
            default: {
                throw UnmarshallingObjectInputFilterImpl.invalidFilterSpec(spec);
            }
        }
        return filter;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Function<UnmarshallingObjectInputFilter.FilterInfo, UnmarshallingObjectInputFilter.Status> parseClassSpec(String spec, ExactMatchFilter exactMatchDenylist, ExactMatchFilter exactMatchAllowlist) {
        void var4_13;
        int lastStar;
        UnmarshallingObjectInputFilter.Status matchReturn;
        Object var4_4 = null;
        boolean denylistElement = spec.startsWith("!");
        UnmarshallingObjectInputFilter.Status status = matchReturn = denylistElement ? UnmarshallingObjectInputFilter.Status.REJECTED : UnmarshallingObjectInputFilter.Status.ALLOWED;
        if (denylistElement) {
            if (spec.length() == 1) {
                throw UnmarshallingObjectInputFilterImpl.invalidFilterSpec(spec);
            }
            spec = spec.substring(1);
        }
        if ((lastStar = spec.lastIndexOf(42)) >= 0) {
            if (lastStar != spec.length() - 1) {
                throw UnmarshallingObjectInputFilterImpl.invalidFilterSpec(spec);
            }
            int firstStar = spec.indexOf(42);
            if (firstStar != lastStar) {
                if (firstStar != lastStar - 1 || !spec.endsWith(".**")) throw UnmarshallingObjectInputFilterImpl.invalidFilterSpec(spec);
                if (spec.length() == 3) {
                    throw UnmarshallingObjectInputFilterImpl.invalidFilterSpec(spec);
                }
                String pkg = spec.substring(0, spec.length() - 2);
                Function<UnmarshallingObjectInputFilter.FilterInfo, UnmarshallingObjectInputFilter.Status> function = filterInfo -> UnmarshallingObjectInputFilterImpl.classNameFor(filterInfo).startsWith(pkg) ? matchReturn : UnmarshallingObjectInputFilter.Status.UNDECIDED;
                return var4_13;
            } else if (spec.endsWith(".*")) {
                if (spec.length() == 2) {
                    throw UnmarshallingObjectInputFilterImpl.invalidFilterSpec(spec);
                }
                String pkg = spec.substring(0, spec.length() - 1);
                Function<UnmarshallingObjectInputFilter.FilterInfo, UnmarshallingObjectInputFilter.Status> function = filterInfo -> UnmarshallingObjectInputFilterImpl.classNameFor(filterInfo).startsWith(pkg) && UnmarshallingObjectInputFilterImpl.classNameFor(filterInfo).lastIndexOf(46) == pkg.length() - 1 ? matchReturn : UnmarshallingObjectInputFilter.Status.UNDECIDED;
                return var4_13;
            } else {
                String startsWith = spec.substring(0, spec.length() - 1);
                Function<UnmarshallingObjectInputFilter.FilterInfo, UnmarshallingObjectInputFilter.Status> function = filterInfo -> UnmarshallingObjectInputFilterImpl.classNameFor(filterInfo).startsWith(startsWith) ? matchReturn : UnmarshallingObjectInputFilter.Status.UNDECIDED;
            }
            return var4_13;
        } else if (denylistElement) {
            if (exactMatchDenylist == null) {
                ExactMatchFilter exactMatchFilter = exactMatchDenylist = new ExactMatchFilter(false);
            }
            exactMatchDenylist.addMatchingClass(spec);
            return var4_13;
        } else {
            if (exactMatchAllowlist == null) {
                ExactMatchFilter exactMatchFilter = exactMatchAllowlist = new ExactMatchFilter(true);
            }
            exactMatchAllowlist.addMatchingClass(spec);
        }
        return var4_13;
    }

    @Override
    public UnmarshallingObjectInputFilter.Status checkInput(UnmarshallingObjectInputFilter.FilterInfo filterInfo) {
        for (Function<UnmarshallingObjectInputFilter.FilterInfo, UnmarshallingObjectInputFilter.Status> func : this.unmarshallingFilters) {
            UnmarshallingObjectInputFilter.Status status = func.apply(filterInfo);
            if (status == UnmarshallingObjectInputFilter.Status.UNDECIDED) continue;
            return status;
        }
        return UnmarshallingObjectInputFilter.Status.UNDECIDED;
    }

    private static String classNameFor(UnmarshallingObjectInputFilter.FilterInfo filterInfo) {
        if (filterInfo.getUnmarshalledClass() == null) {
            return "";
        }
        return filterInfo.getUnmarshalledClass().getName();
    }

    private static IllegalArgumentException invalidFilterSpec(String spec) {
        return UnmarshallingObjectInputFilterImpl.invalidFilterSpec(spec, null);
    }

    private static IllegalArgumentException invalidFilterSpec(String spec, Throwable cause) {
        return new IllegalArgumentException(String.format("Invalid unmarshalling filter specification '%s'", spec), cause);
    }

    private static class ExactMatchFilter
    implements Function<UnmarshallingObjectInputFilter.FilterInfo, UnmarshallingObjectInputFilter.Status> {
        private final Set<String> matches = new HashSet<String>();
        private final UnmarshallingObjectInputFilter.Status matchResult;

        private ExactMatchFilter(boolean forAllowlist) {
            this.matchResult = forAllowlist ? UnmarshallingObjectInputFilter.Status.ALLOWED : UnmarshallingObjectInputFilter.Status.REJECTED;
        }

        private void addMatchingClass(String name) {
            this.matches.add(name);
        }

        private boolean isForAllowlist() {
            return this.matchResult == UnmarshallingObjectInputFilter.Status.ALLOWED;
        }

        @Override
        public UnmarshallingObjectInputFilter.Status apply(UnmarshallingObjectInputFilter.FilterInfo filterInfo) {
            return this.matches.contains(UnmarshallingObjectInputFilterImpl.classNameFor(filterInfo)) ? this.matchResult : UnmarshallingObjectInputFilter.Status.UNDECIDED;
        }
    }
}

