/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2014 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.marshalling;

import java.io.IOException;

/**
 * A producer of stream headers.
 */
public interface StreamHeader {
    /**
     * Read the stream header from the stream.
     *
     * @param input the stream header
     * @throws IOException if the header is invalid or an error occurs
     */
    void readHeader(ByteInput input) throws IOException;

    /**
     * Write the stream header to the stream.
     *
     * @param output the stream header
     * @throws IOException if an error occurs
     */
    void writeHeader(ByteOutput output) throws IOException;
}
