/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import org.jboss.marshalling.SimpleDataInput;

public abstract class AbstractObjectInput
extends SimpleDataInput
implements ObjectInput {
    protected AbstractObjectInput(int bufferSize) {
        super(bufferSize);
    }

    @Override
    public final Object readObject() throws ClassNotFoundException, IOException {
        return this.doReadObject(false);
    }

    public final Object readObjectUnshared() throws ClassNotFoundException, IOException {
        return this.doReadObject(true);
    }

    protected abstract Object doReadObject(boolean var1) throws ClassNotFoundException, IOException;

    public <T> T readObject(Class<T> type) throws ClassNotFoundException, IOException {
        Object obj = this.doReadObject(false);
        try {
            return type.cast(obj);
        }
        catch (ClassCastException e) {
            throw AbstractObjectInput.wrongType(e, type, obj.getClass());
        }
    }

    public <T> T readObjectUnshared(Class<T> type) throws ClassNotFoundException, IOException {
        Object obj = this.doReadObject(true);
        try {
            return type.cast(obj);
        }
        catch (ClassCastException e) {
            throw AbstractObjectInput.wrongType(e, type, obj.getClass());
        }
    }

    private static InvalidObjectException wrongType(ClassCastException e, Class<?> expected, Class<?> actual) {
        InvalidObjectException ioe = new InvalidObjectException("Object is of the wrong type (expected " + String.valueOf(expected) + ", got " + String.valueOf(actual) + ")");
        ioe.initCause(e);
        return ioe;
    }
}

