/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.util.Arrays;
import org.jboss.marshalling.ClassNameTransformer;

final class JavaEE2JakartaEEClassNameTransformer
implements ClassNameTransformer {
    private static final String JAVAEE_PACKAGE_PREFIX = "javax.";
    private static final String JAKARTAEE_PACKAGE_PREFIX = "jakarta.";
    private static final String[] subpackages = new String[]{"activation.", "annotation.", "batch.", "decorator.", "ejb.", "el.", "enterprise.", "faces.", "inject.", "interceptor.", "jms.", "json.", "jws.", "mail.", "persistence.", "resource.", "security.auth.message.", "security.enterprise.", "security.jacc.", "servlet.", "transaction.", "validation.", "websocket.", "ws.rs.", "xml.bind.", "xml.soap.", "xml.ws."};

    JavaEE2JakartaEEClassNameTransformer() {
    }

    @Override
    public String transformInput(String className) {
        return this.transform(className, JAVAEE_PACKAGE_PREFIX, JAKARTAEE_PACKAGE_PREFIX);
    }

    @Override
    public String transformOutput(String className) {
        return this.transform(className, JAKARTAEE_PACKAGE_PREFIX, JAVAEE_PACKAGE_PREFIX);
    }

    private String transform(String className, String sourcePrefix, String targetPrefix) {
        if (className.startsWith(sourcePrefix)) {
            String classNameNoPrefix = className.substring(sourcePrefix.length());
            int index = Math.abs(Arrays.binarySearch(subpackages, classNameNoPrefix)) - 2;
            return index >= 0 && classNameNoPrefix.startsWith(subpackages[index]) ? targetPrefix + classNameNoPrefix : className;
        }
        return className;
    }

    static {
        Arrays.sort(subpackages);
    }
}

