/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossas.servermanager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.jbossas.servermanager.Server;
import org.jboss.jbossas.servermanager.ServerController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerManager {
    public static final String SYSTEM_PROPERTY_JBOSSAS_STARTUP_TIMEOUT = "jbossas.startup.timeout";
    public static final String SYSTEM_PROPERTY_JBOSSAS_SHUTDOWN_TIMEOUT = "jbossas.shutdown.timeout";
    private static final int WAIT_TIME = Integer.parseInt(System.getProperty("jbossas.shutdown.timeout", "45"));
    private static final int START_TIME = Integer.parseInt(System.getProperty("jbossas.startup.timeout", "120"));
    private String jbossHome;
    private String jvm = "java";
    private String javaHome;
    private String udpGroup;
    private List<Server> servers = new ArrayList<Server>();

    public ServerManager() {
        Thread cleanupThread = new Thread(){

            public void run() {
                for (Server server : ServerManager.this.servers) {
                    if (server == null || !server.isRunning()) continue;
                    System.err.println("Testsuite shutdown hook found server \"" + server.getName() + "\" still running; stopping it.");
                    try {
                        ServerController.stopServer(server, ServerManager.this);
                    }
                    catch (IOException e) {
                        System.err.println("Testsuite shutdown hook failed to stop server(s) on shutdown.");
                        e.printStackTrace(System.err);
                    }
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(cleanupThread);
    }

    public void addServer(Server newServer) {
        newServer.setManager(this);
        this.servers.add(newServer);
    }

    public Server getServer(String name) {
        for (Server server : this.servers) {
            if (!server.getName().equals(name)) continue;
            return server;
        }
        throw new IllegalArgumentException("There is no server named: " + name);
    }

    public void delServer(String name) {
        try {
            this.servers.remove(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("There is no server named: " + name, e);
        }
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public void startServer(String serverName) throws IOException {
        ServerController.startServer(this.getServer(serverName), this);
    }

    public void stopServer(String name) throws IOException {
        ServerController.stopServer(this.getServer(name), this);
    }

    public String getJavaExecutable() throws IOException {
        return new File(this.javaHome + File.separator + "bin", this.jvm).getCanonicalPath();
    }

    public void setJvm(String jvm) {
        this.jvm = jvm;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public void setJbossHome(String jbossHome) {
        this.jbossHome = jbossHome;
    }

    protected String getStartClasspath() {
        File runjar = new File(this.jbossHome + "/bin/run.jar");
        File javaJar = new File(this.javaHome + "/lib/tools.jar");
        return runjar.toString() + File.pathSeparator + javaJar.toString();
    }

    protected String getStopClasspath() {
        File shutdownJar = new File(this.jbossHome + "/bin/shutdown.jar");
        File clientJar = new File(this.jbossHome + "/client/jbossall-client.jar");
        File logJar = new File(this.jbossHome + "/client/jboss-common.jar");
        return shutdownJar.toString() + File.pathSeparator + clientJar.toString() + File.pathSeparator + logJar.toString();
    }

    public String getJBossHome() {
        return this.jbossHome;
    }

    public String getJavaEndorsedDirs() {
        String jbossHome = this.jbossHome;
        String slash = "/";
        String adjustedJBossHome = jbossHome.endsWith("/") ? jbossHome : jbossHome + "/";
        return adjustedJBossHome + "lib/endorsed/";
    }

    public int getShutdownTimeout() {
        return WAIT_TIME;
    }

    public int getStartupTimeout() {
        return START_TIME;
    }

    protected String getUdpGroup() {
        return this.udpGroup;
    }

    public void setUdpGroup(String udpGroup) {
        this.udpGroup = udpGroup;
    }
}

