/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.persistence;

import java.io.Serializable;
import java.util.Set;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.ArrayValue;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedArrayValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedCollectionValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedCompositeValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedEnumValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedGenericValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedManagedObject;
import org.jboss.system.server.profileservice.persistence.xml.PersistedProperty;
import org.jboss.system.server.profileservice.persistence.xml.PersistedSimpleValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedTableValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedValue;

public class ManagedObjectPeristenceHandler {
    MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();
    private static final Logger log = Logger.getLogger(ManagedObjectPeristenceHandler.class);

    public boolean processManagedObject(PersistedManagedObject moElement, ManagedObject mo) {
        if (moElement == null) {
            throw new IllegalArgumentException("Null rootElement.");
        }
        if (mo == null) {
            throw new IllegalArgumentException("null managedObject");
        }
        moElement.setName(mo.getName());
        moElement.setClassName(mo.getAttachmentName());
        if (moElement.getOriginalName() == null) {
            moElement.setOriginalName(mo.getName());
        }
        boolean changed = false;
        Set propertyNames = mo.getPropertyNames();
        for (String propertyName : propertyNames) {
            boolean propertyChanged;
            ManagedProperty property = mo.getProperty(propertyName);
            if (property == null) {
                throw new IllegalStateException("unable to find propery: " + property);
            }
            if (!property.hasViewUse(ViewUse.CONFIGURATION)) continue;
            PersistedProperty propertyElement = (PersistedProperty)moElement.get(propertyName);
            if (propertyElement == null) {
                propertyElement = new PersistedProperty(property.getName());
            }
            if (!(propertyChanged = this.processManagedProperty(propertyElement, propertyName, property))) continue;
            changed = true;
            moElement.put(propertyName, propertyElement);
        }
        return changed;
    }

    protected boolean processManagedProperty(PersistedProperty persistedProperty, String name, ManagedProperty property) {
        boolean trace = log.isTraceEnabled();
        PropertyInfo propertyInfo = (PropertyInfo)property.getField("propertyInfo", PropertyInfo.class);
        if (propertyInfo != null && !propertyInfo.isReadable()) {
            if (trace) {
                log.trace((Object)("property " + name + "is not readable"));
            }
            return false;
        }
        MetaValue value = property.getValue();
        PersistedValue persistedValue = persistedProperty.getValue();
        boolean changed = false;
        if (value != null) {
            if (persistedValue == null) {
                persistedValue = ManagedObjectPeristenceHandler.createPersistedValue(value.getMetaType());
            }
            changed = this.processMetaValue(persistedValue, value);
        }
        persistedProperty.setValue(persistedValue);
        return changed;
    }

    protected boolean processMetaValue(PersistedValue valueElement, MetaValue value) {
        if (value == null) {
            return false;
        }
        boolean changed = false;
        MetaType metaType = value.getMetaType();
        if (metaType.isSimple()) {
            changed = this.processSimpleValue((PersistedSimpleValue)valueElement, (SimpleValue)value);
        } else if (metaType.isEnum()) {
            changed = this.processEnumValue((PersistedEnumValue)valueElement, (EnumValue)value);
        } else if (metaType.isCollection()) {
            changed = this.processCollectionValue((PersistedCollectionValue)valueElement, (CollectionValue)value);
        } else if (metaType.isGeneric()) {
            changed = this.processGenericValue((PersistedGenericValue)valueElement, (GenericValue)value);
        } else if (metaType.isComposite()) {
            changed = this.processCompositeValue((PersistedCompositeValue)valueElement, (CompositeValue)value);
        } else if (metaType.isArray()) {
            changed = this.processArrayValue((PersistedArrayValue)valueElement, (ArrayValue)value);
        } else {
            if (metaType.isTable()) {
                throw new UnsupportedOperationException("Persisting a table value.");
            }
            throw new IllegalStateException("unknown metaType");
        }
        return changed;
    }

    protected boolean processSimpleValue(PersistedSimpleValue valueElement, SimpleValue value) {
        valueElement.setValue(this.convertSimple2String(value));
        return true;
    }

    protected boolean processEnumValue(PersistedEnumValue enumElement, EnumValue value) {
        enumElement.setValue(value.getValue());
        return true;
    }

    protected boolean processCollectionValue(PersistedCollectionValue valueElement, CollectionValue value) {
        boolean changed = false;
        for (MetaValue child : value.getElements()) {
            PersistedValue persistedValue = ManagedObjectPeristenceHandler.createPersistedValue(child.getMetaType());
            if (this.processMetaValue(persistedValue, child)) {
                changed = true;
            }
            valueElement.addValue(persistedValue);
        }
        return changed;
    }

    protected boolean processGenericValue(PersistedGenericValue genericElement, GenericValue value) {
        Serializable o = value.getValue();
        if (o == null) {
            return false;
        }
        boolean changed = false;
        if (o instanceof ManagedObject) {
            PersistedManagedObject mo = new PersistedManagedObject();
            if (this.processManagedObject(mo, (ManagedObject)o)) {
                changed = true;
            }
            genericElement.setManagedObject(mo);
            return changed;
        }
        throw new IllegalStateException("The value of GenericValue must be a ManagedObject: " + value);
    }

    protected boolean processArrayValue(PersistedArrayValue array, ArrayValue value) {
        ArrayMetaType metaType = value.getMetaType();
        if (!metaType.getElementType().isSimple()) {
            throw new UnsupportedOperationException("Persisting a non primitive array.");
        }
        boolean changed = false;
        for (int i = 0; i < value.getLength(); ++i) {
            MetaValue metaValue = (MetaValue)value.getValue(i);
            PersistedValue persistedValue = ManagedObjectPeristenceHandler.createPersistedValue(metaType.getElementType());
            if (this.processMetaValue(persistedValue, metaValue)) {
                changed = true;
            }
            array.addValue(persistedValue);
        }
        return changed;
    }

    protected boolean processCompositeValue(PersistedCompositeValue composite, CompositeValue value) {
        CompositeMetaType metaType = value.getMetaType();
        boolean changed = false;
        for (String item : metaType.itemSet()) {
            MetaValue itemValue = value.get(item);
            MetaType itemType = null;
            itemType = itemValue != null ? itemValue.getMetaType() : metaType.getType(item);
            PersistedValue persistedValue = ManagedObjectPeristenceHandler.createPersistedValue(itemType);
            persistedValue.setName(item);
            if (this.processMetaValue(persistedValue, itemValue)) {
                changed = true;
            }
            composite.put(item, persistedValue);
        }
        return changed;
    }

    protected static PersistedValue createPersistedValue(MetaType metaType) {
        if (metaType.isSimple()) {
            return new PersistedSimpleValue();
        }
        if (metaType.isEnum()) {
            return new PersistedEnumValue();
        }
        if (metaType.isCollection()) {
            return new PersistedCollectionValue();
        }
        if (metaType.isGeneric()) {
            return new PersistedGenericValue();
        }
        if (metaType.isComposite()) {
            return new PersistedCompositeValue();
        }
        if (metaType.isTable()) {
            return new PersistedTableValue();
        }
        if (metaType.isArray()) {
            return new PersistedArrayValue();
        }
        throw new IllegalStateException("unknown metaType");
    }

    protected String convertSimple2String(SimpleValue value) {
        if (value == null) {
            return null;
        }
        Object unwrappedValue = this.metaValueFactory.unwrap((MetaValue)value);
        if (unwrappedValue == null) {
            return null;
        }
        return "" + unwrappedValue;
    }
}

