/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs.spi;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.CodeSigner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.logging.Logger;
import org.jboss.vfs.TempDir;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.spi.EnumerationIterable;
import org.jboss.vfs.spi.FileSystem;
import org.jboss.vfs.util.PathTokenizer;

public final class JavaZipFileSystem
implements FileSystem {
    private static final Logger log = Logger.getLogger((String)"org.jboss.vfs.zip");
    private final JarFile zipFile;
    private final File archiveFile;
    private final long zipTime;
    private final ZipNode rootNode;
    private final TempDir tempDir;
    private final File contentsDir;

    public JavaZipFileSystem(String name, InputStream inputStream, TempDir tempDir) throws IOException {
        this(tempDir.createFile(name, inputStream), tempDir);
    }

    public JavaZipFileSystem(File archiveFile, TempDir tempDir) throws IOException {
        JarFile zipFile;
        this.zipTime = archiveFile.lastModified();
        this.zipFile = zipFile = new JarFile(archiveFile);
        this.archiveFile = archiveFile;
        this.tempDir = tempDir;
        Enumeration<JarEntry> entries = zipFile.entries();
        ZipNode rootNode = new ZipNode(new HashMap(), "", null);
        for (JarEntry entry : JavaZipFileSystem.iter(entries)) {
            Map children;
            String token;
            String name = entry.getName();
            boolean isDirectory = entry.isDirectory();
            List<String> tokens = PathTokenizer.getTokens(name);
            ZipNode node = rootNode;
            Iterator<String> it = tokens.iterator();
            while (it.hasNext() && !PathTokenizer.isCurrentToken(token = it.next()) && !PathTokenizer.isReverseToken(token) && (children = node.children) != null) {
                String lcToken = token.toLowerCase();
                ZipNode child = (ZipNode)children.get(lcToken);
                if (child == null) {
                    child = it.hasNext() || isDirectory ? new ZipNode(new HashMap(), token, null) : new ZipNode(null, token, entry);
                    children.put(lcToken, child);
                }
                node = child;
            }
        }
        this.rootNode = rootNode;
        this.contentsDir = tempDir.getFile("contents");
        this.contentsDir.mkdir();
        log.tracef("Created zip filesystem for file %s in temp dir %s", new Object[]{archiveFile, tempDir});
    }

    private static <T> Iterable<T> iter(Enumeration<T> entries) {
        return new EnumerationIterable<T>(entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getFile(VirtualFile mountPoint, VirtualFile target) throws IOException {
        ZipNode zipNode = this.getExistingZipNode(mountPoint, target);
        File cachedFile = zipNode.cachedFile;
        if (cachedFile != null) {
            return cachedFile;
        }
        ZipNode zipNode2 = zipNode;
        synchronized (zipNode2) {
            cachedFile = zipNode.cachedFile;
            if (cachedFile != null) {
                return cachedFile;
            }
            JarEntry zipEntry = zipNode.entry;
            String name = target.getPathNameRelativeTo(mountPoint);
            cachedFile = this.buildFile(this.contentsDir, name);
            if (zipEntry == null) {
                cachedFile.mkdir();
            } else {
                VFSUtils.copyStreamAndClose(this.zipFile.getInputStream(zipEntry), new BufferedOutputStream(new FileOutputStream(cachedFile)));
            }
            zipNode.cachedFile = cachedFile;
            return cachedFile;
        }
    }

    @Override
    public InputStream openInputStream(VirtualFile mountPoint, VirtualFile target) throws IOException {
        ZipNode zipNode = this.getExistingZipNode(mountPoint, target);
        File cachedFile = zipNode.cachedFile;
        if (cachedFile != null) {
            return new FileInputStream(cachedFile);
        }
        if (this.rootNode == zipNode) {
            return new FileInputStream(this.archiveFile);
        }
        JarEntry entry = zipNode.entry;
        if (entry == null) {
            throw new IOException("Not a file: \"" + target.getPathName() + "\"");
        }
        return this.zipFile.getInputStream(entry);
    }

    @Override
    public boolean delete(VirtualFile mountPoint, VirtualFile target) {
        ZipNode zipNode = this.getZipNode(mountPoint, target);
        if (zipNode == null) {
            return false;
        }
        File cachedFile = zipNode.cachedFile;
        return cachedFile != null && cachedFile.delete();
    }

    @Override
    public long getSize(VirtualFile mountPoint, VirtualFile target) {
        ZipNode zipNode = this.getZipNode(mountPoint, target);
        if (zipNode == null) {
            return 0L;
        }
        File cachedFile = zipNode.cachedFile;
        JarEntry entry = zipNode.entry;
        if (zipNode == this.rootNode) {
            return this.archiveFile.length();
        }
        return cachedFile != null ? cachedFile.length() : (entry == null ? 0L : entry.getSize());
    }

    @Override
    public long getLastModified(VirtualFile mountPoint, VirtualFile target) {
        ZipNode zipNode = this.getZipNode(mountPoint, target);
        if (zipNode == null) {
            return 0L;
        }
        File cachedFile = zipNode.cachedFile;
        JarEntry entry = zipNode.entry;
        return cachedFile != null ? cachedFile.lastModified() : (entry == null ? this.zipTime : entry.getTime());
    }

    @Override
    public boolean exists(VirtualFile mountPoint, VirtualFile target) {
        ZipNode zipNode = this.rootNode.find(mountPoint, target);
        if (zipNode == null) {
            return false;
        }
        File cachedFile = zipNode.cachedFile;
        return cachedFile == null || cachedFile.exists();
    }

    @Override
    public boolean isFile(VirtualFile mountPoint, VirtualFile target) {
        ZipNode zipNode = this.rootNode.find(mountPoint, target);
        return zipNode != null && zipNode.entry != null;
    }

    @Override
    public boolean isDirectory(VirtualFile mountPoint, VirtualFile target) {
        ZipNode zipNode = this.rootNode.find(mountPoint, target);
        return zipNode != null && zipNode.entry == null;
    }

    @Override
    public List<String> getDirectoryEntries(VirtualFile mountPoint, VirtualFile target) {
        ZipNode zipNode = this.getZipNode(mountPoint, target);
        if (zipNode == null) {
            return Collections.emptyList();
        }
        Map children = zipNode.children;
        if (children == null) {
            return Collections.emptyList();
        }
        Collection values = children.values();
        ArrayList<String> names = new ArrayList<String>(values.size());
        for (ZipNode node : values) {
            names.add(node.name);
        }
        return names;
    }

    @Override
    public CodeSigner[] getCodeSigners(VirtualFile mountPoint, VirtualFile target) {
        ZipNode zipNode = this.getZipNode(mountPoint, target);
        if (zipNode == null) {
            return null;
        }
        JarEntry jarEntry = zipNode.entry;
        return jarEntry.getCodeSigners();
    }

    private ZipNode getZipNode(VirtualFile mountPoint, VirtualFile target) {
        ZipNode zipNode = this.rootNode.find(mountPoint, target);
        if (zipNode == null) {
            return null;
        }
        return zipNode;
    }

    private ZipNode getExistingZipNode(VirtualFile mountPoint, VirtualFile target) throws FileNotFoundException {
        ZipNode zipNode = this.rootNode.find(mountPoint, target);
        if (zipNode == null) {
            throw new FileNotFoundException(target.getPathName());
        }
        return zipNode;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void close() throws IOException {
        log.tracef("Closing zip filesystem %s", new Object[]{this});
        VFSUtils.safeClose(new Closeable(){

            @Override
            public void close() throws IOException {
                JavaZipFileSystem.this.zipFile.close();
            }
        });
        this.tempDir.close();
    }

    private File buildFile(File contentsDir, String name) {
        List<String> tokens = PathTokenizer.getTokens(name);
        File currentFile = contentsDir;
        for (String token : tokens) {
            currentFile = new File(currentFile, token);
        }
        currentFile.getParentFile().mkdirs();
        return currentFile;
    }

    private static final class ZipNode {
        private final Map<String, ZipNode> children;
        private final String name;
        private final JarEntry entry;
        private volatile File cachedFile;

        private ZipNode(Map<String, ZipNode> children, String name, JarEntry entry) {
            this.children = children;
            this.name = name;
            this.entry = entry;
        }

        private ZipNode find(VirtualFile mountPoint, VirtualFile target) {
            if (mountPoint.equals(target)) {
                return this;
            }
            ZipNode parent = this.find(mountPoint, target.getParent());
            if (parent == null) {
                return null;
            }
            Map<String, ZipNode> children = parent.children;
            if (children == null) {
                return null;
            }
            return children.get(target.getLowerCaseName());
        }
    }
}

