/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MemberSource;

public class SerialVersionUIDComputer {
    private SerialVersionUIDComputer() {
        throw new IllegalAccessError("Utility class");
    }

    public static long compute(JavaClassSource source) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeUTF(source.getQualifiedName());
            int classMods = 0;
            if (source.isPublic()) {
                classMods |= 1;
            }
            if (source.isFinal()) {
                classMods |= 0x10;
            }
            if (source.isInterface()) {
                classMods |= 0x200;
            }
            if (source.isAbstract()) {
                classMods |= 0x400;
            }
            dout.writeInt(classMods);
            List members = source.getMembers();
            for (MemberSource memberSource : members) {
                if (memberSource.isPrivate()) continue;
                dout.writeUTF(memberSource.getName());
                dout.writeUTF(memberSource.toString().replace('/', '.'));
            }
            dout.flush();
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] byArray = md.digest(bout.toByteArray());
            long hash = 0L;
            for (int i = Math.min(byArray.length, 8) - 1; i >= 0; --i) {
                hash = hash << 8 | (long)(byArray[i] & 0xFF);
            }
            return hash;
        }
        catch (IOException ex) {
            throw new RuntimeException("Error while calculating serialVersionUID", ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SecurityException(ex.getMessage());
        }
    }
}

