/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster;

import java.util.Collections;
import java.util.List;
import org.jboss.forge.roaster.Problem;

public class ParserException
extends RuntimeException {
    private static final long serialVersionUID = 642493448571856848L;
    private final List<Problem> problems;

    public ParserException() {
        this.problems = Collections.emptyList();
    }

    public ParserException(String message) {
        super(message);
        this.problems = Collections.emptyList();
    }

    public ParserException(Throwable cause) {
        super(cause);
        this.problems = Collections.emptyList();
    }

    public ParserException(String message, Throwable cause) {
        super(message, cause);
        this.problems = Collections.emptyList();
    }

    public ParserException(String message, List<Problem> problems) {
        super(message);
        this.problems = problems;
    }

    public ParserException(List<Problem> problems) {
        super(ParserException.getProblemsMessage(problems));
        this.problems = problems;
    }

    public List<Problem> getProblems() {
        return Collections.unmodifiableList(this.problems);
    }

    private static String getProblemsMessage(List<Problem> problems) {
        StringBuilder sb = new StringBuilder();
        if (!problems.isEmpty()) {
            for (Problem problem : problems) {
                sb.append("- ").append(problem.getMessage()).append('\n');
            }
            return sb.toString();
        }
        return sb.toString();
    }
}

