/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.plugins.vfs;

import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VirtualFileVisitor;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.vfs.helpers.AbstractVirtualFileFilterWithAttributes;

public class VFSResourceVisitor
extends AbstractVirtualFileFilterWithAttributes
implements VirtualFileVisitor {
    private VirtualFile[] roots;
    private VirtualFile root;
    private String rootPath;
    private String rootPathWithSlash;
    private ClassFilter included;
    private ClassFilter excluded;
    private ClassLoader classLoader;
    private ResourceVisitor visitor;
    private ResourceFilter filter;

    public static void visit(VirtualFile[] roots, ClassFilter included, ClassFilter excluded, ClassLoader classLoader, ResourceVisitor visitor, ResourceFilter filter) {
        VFSResourceVisitor vfsVisitor = new VFSResourceVisitor(roots, included, excluded, classLoader, visitor, filter);
        for (VirtualFile root : roots) {
            try {
                vfsVisitor.setRoot(root);
                root.visit((VirtualFileVisitor)vfsVisitor);
            }
            catch (Exception e) {
                throw new Error("Error visiting " + root, e);
            }
        }
    }

    VFSResourceVisitor(VirtualFile[] roots, ClassFilter included, ClassFilter excluded, ClassLoader classLoader, ResourceVisitor visitor, ResourceFilter filter) {
        if (roots == null) {
            throw new IllegalArgumentException("Null roots");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("Null visitor");
        }
        this.roots = roots;
        this.included = included;
        this.excluded = excluded;
        this.classLoader = classLoader;
        this.visitor = visitor;
        this.filter = filter;
    }

    void setRoot(VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        this.root = root;
        this.rootPath = root.getPathName();
        this.rootPathWithSlash = this.rootPath + "/";
    }

    public VisitorAttributes getAttributes() {
        VisitorAttributes attributes = new VisitorAttributes();
        attributes.setIncludeRoot(false);
        attributes.setRecurseFilter((VirtualFileFilter)this);
        return attributes;
    }

    public boolean accepts(VirtualFile file) {
        if (file.equals((Object)this.root)) {
            return true;
        }
        for (VirtualFile other : this.roots) {
            if (!file.equals((Object)other)) continue;
            return false;
        }
        return true;
    }

    public void visit(VirtualFile file) {
        try {
            if (!file.isLeaf()) {
                return;
            }
            String path = file.getPathName();
            if (path.equals(this.rootPath)) {
                path = "";
            } else if (path.startsWith(this.rootPathWithSlash)) {
                path = path.substring(this.rootPathWithSlash.length());
            }
            if (this.included != null && !this.included.matchesResourcePath(path)) {
                return;
            }
            if (this.excluded != null && this.excluded.matchesResourcePath(path)) {
                return;
            }
            ResourceContext resource = new ResourceContext(file.toURL(), path, this.classLoader);
            if (this.filter == null || this.filter.accepts(resource)) {
                this.visitor.visit(resource);
            }
        }
        catch (Exception e) {
            throw new Error("Error visiting " + file, e);
        }
    }
}

