/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet5;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.test.spi.ContainerMethodExecutor;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.command.CommandCallback;
import org.jboss.arquillian.protocol.servlet5.ServletProtocolConfiguration;
import org.jboss.arquillian.protocol.servlet5.ServletURIHandler;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;

public class ServletMethodExecutor
implements ContainerMethodExecutor {
    public static final String ARQUILLIAN_SERVLET_NAME = "ArquillianServletRunnerEE9";
    public static final String ARQUILLIAN_SERVLET_MAPPING = "/ArquillianServletRunnerEE9";
    private static final Logger log = Logger.getLogger(ContainerMethodExecutor.class.getName());
    protected ServletURIHandler uriHandler;
    protected CommandCallback callback;
    protected ServletProtocolConfiguration config;

    protected ServletMethodExecutor() {
    }

    public ServletMethodExecutor(ServletProtocolConfiguration config, Collection<HTTPContext> contexts, CommandCallback callback) {
        if (config == null) {
            throw new IllegalArgumentException("ServletProtocolConfiguration must be specified");
        }
        if (contexts == null || contexts.size() == 0) {
            throw new IllegalArgumentException("HTTPContext must be specified");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Callback must be specified");
        }
        this.config = config;
        this.uriHandler = new ServletURIHandler(config, contexts);
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult invoke(TestMethodExecutor testMethodExecutor) {
        if (testMethodExecutor == null) {
            throw new IllegalArgumentException("TestMethodExecutor must be specified");
        }
        URI targetBaseURI = this.uriHandler.locateTestServlet(testMethodExecutor.getMethod());
        Class<?> testClass = testMethodExecutor.getInstance().getClass();
        Timer eventTimer = null;
        ReentrantLock timerLock = new ReentrantLock();
        AtomicBoolean isCanceled = new AtomicBoolean();
        try {
            String urlEncodedMethodName = URLEncoder.encode(testMethodExecutor.getMethodName(), "UTF-8");
            String url = targetBaseURI.toASCIIString() + "/ArquillianServletRunnerEE9?outputMode=serializedObject&className=" + testClass.getName() + "&methodName=" + urlEncodedMethodName;
            String eventUrl = targetBaseURI.toASCIIString() + "/ArquillianServletRunnerEE9?outputMode=serializedObject&className=" + testClass.getName() + "&methodName=" + urlEncodedMethodName + "&cmd=event";
            eventTimer = this.createCommandServicePullTimer(eventUrl, timerLock, isCanceled);
            TestResult testResult = this.executeWithRetry(url, TestResult.class);
            return testResult;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error launching test " + testClass.getName() + " " + testMethodExecutor.getMethod(), e);
        }
        finally {
            if (eventTimer != null) {
                eventTimer.cancel();
                timerLock.lock();
                try {
                    isCanceled.set(true);
                }
                finally {
                    timerLock.unlock();
                }
            }
        }
    }

    protected <T> T executeWithRetry(String url, Class<T> type) throws Exception {
        long timeoutTime = System.currentTimeMillis() + 1000L;
        boolean interrupted = false;
        while (timeoutTime > System.currentTimeMillis()) {
            T o = this.execute(url, type, null);
            if (o != null) {
                return o;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        throw new IllegalStateException("Error launching request at " + url + ". No result returned");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T execute(String url, Class<T> returnType, Object requestObject) throws Exception {
        URLConnection connection = new URL(url).openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            throw new IllegalStateException("Not an http connection! " + connection);
        }
        HttpURLConnection httpConnection = (HttpURLConnection)connection;
        httpConnection.setUseCaches(false);
        httpConnection.setDefaultUseCaches(false);
        httpConnection.setDoInput(true);
        this.prepareHttpConnection(httpConnection);
        try {
            if (requestObject != null) {
                httpConnection.setRequestMethod("POST");
                httpConnection.setDoOutput(true);
                httpConnection.setRequestProperty("Content-Type", "application/octet-stream");
            }
            if (requestObject != null) {
                ObjectOutputStream ous = new ObjectOutputStream(httpConnection.getOutputStream());
                try {
                    ous.writeObject(requestObject);
                }
                catch (Exception e2) {
                    throw new RuntimeException("Error sending request Object, " + requestObject, e2);
                }
                finally {
                    ous.flush();
                    ous.close();
                }
            }
            try {
                httpConnection.getResponseCode();
            }
            catch (ConnectException e) {
                T e2 = null;
                httpConnection.disconnect();
                return e2;
            }
            if (httpConnection.getResponseCode() == 200) {
                Object o;
                try (ObjectInputStream ois = new ObjectInputStream(httpConnection.getInputStream());){
                    o = ois.readObject();
                }
                if (!returnType.isInstance(o)) {
                    throw new IllegalStateException("Error reading results, expected a " + returnType.getName() + " but got " + o);
                }
                T t = returnType.cast(o);
                return t;
            }
            if (httpConnection.getResponseCode() == 204) {
                T t = null;
                return t;
            }
            if (httpConnection.getResponseCode() != 404) {
                throw new IllegalStateException("Error launching test at " + url + ". Got " + httpConnection.getResponseCode() + " (" + httpConnection.getResponseMessage() + ")");
            }
        }
        finally {
            httpConnection.disconnect();
        }
        return null;
    }

    protected void prepareHttpConnection(HttpURLConnection connection) {
    }

    protected Timer createCommandServicePullTimer(final String eventUrl, final Lock timerLock, final AtomicBoolean isCanceled) {
        if (this.config.getPullInMilliSeconds() == null || this.config.getPullInMilliSeconds() <= 0) {
            log.warning("The Servlet Protocol has been configured with a pullInMilliSeconds interval of " + this.config.getPullInMilliSeconds() + ". The effect of this is that the Command Service has been disabled. Depending on which features you use, this might cause serious delays. Be on high alert for  possible timeout runtime exceptions.");
            return null;
        }
        Timer eventTimer = new Timer();
        eventTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                block8: {
                    timerLock.lock();
                    try {
                        if (isCanceled.get()) {
                            return;
                        }
                        Object o = ServletMethodExecutor.this.execute(eventUrl, Object.class, null);
                        if (o == null) break block8;
                        if (o instanceof Command) {
                            Command command = (Command)o;
                            ServletMethodExecutor.this.callback.fired(command);
                            ServletMethodExecutor.this.execute(eventUrl, Object.class, command);
                            break block8;
                        }
                        throw new RuntimeException("Recived a non " + Command.class.getName() + " object on event channel");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        timerLock.unlock();
                    }
                }
            }
        }, 0L, (long)this.config.getPullInMilliSeconds().intValue());
        return eventTimer;
    }
}

