/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.enricher.AbstractSearchContextEnricher;
import org.jboss.arquillian.graphene.enricher.ClassImposterizer;
import org.jboss.arquillian.graphene.enricher.ReflectionHelper;
import org.jboss.arquillian.graphene.enricher.WebElementUtils;
import org.jboss.arquillian.graphene.enricher.exception.PageFragmentInitializationException;
import org.jboss.arquillian.graphene.findby.FindByUtilities;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.proxy.GrapheneContextualHandler;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.MethodInterceptor;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.MethodProxy;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneConfiguration;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageFragmentEnricher
extends AbstractSearchContextEnricher {
    @Inject
    private Instance<GrapheneConfiguration> configuration;

    public PageFragmentEnricher() {
    }

    public PageFragmentEnricher(Instance<GrapheneConfiguration> configuration) {
        this.configuration = configuration;
    }

    public void enrich(SearchContext searchContext, Object target) {
        List<Field> fields = FindByUtilities.getListOfFieldsAnnotatedWithFindBys(target);
        for (Field field : fields) {
            SearchContext localSearchContext;
            GrapheneContext grapheneContext;
            GrapheneContext grapheneContext2 = grapheneContext = searchContext == null ? null : ((GrapheneProxyInstance)searchContext).getGrapheneContext();
            if (grapheneContext == null) {
                grapheneContext = GrapheneContext.getContextFor(ReflectionHelper.getQualifier(field.getAnnotations()));
                localSearchContext = grapheneContext.getWebDriver(new Class[]{SearchContext.class});
            } else {
                localSearchContext = searchContext;
            }
            if (this.isPageFragmentClass(field.getType(), target)) {
                this.setupPageFragment(localSearchContext, target, field);
                continue;
            }
            try {
                if (!field.getType().isAssignableFrom(List.class) || !this.isPageFragmentClass(this.getListType(field), target)) continue;
                this.setupPageFragmentList(localSearchContext, target, field);
            }
            catch (ClassNotFoundException e) {
                throw new PageFragmentInitializationException(e.getMessage(), e);
            }
        }
    }

    public Object[] resolve(SearchContext searchContext, Method method, Object[] resolvedParams) {
        return resolvedParams;
    }

    protected final boolean isPageFragmentClass(Class<?> clazz, Object target) {
        if (Modifier.isInterface(clazz.getModifiers())) {
            return false;
        }
        Class<?> outerClass = clazz.getDeclaringClass();
        if (outerClass == null || Modifier.isStatic(clazz.getModifiers())) {
            return ReflectionHelper.hasConstructor(clazz, new Class[0]);
        }
        return ReflectionHelper.hasConstructor(clazz, outerClass);
    }

    protected final <T> List<T> createPageFragmentList(final Class<T> clazz, final SearchContext searchContext, final By rootBy) {
        GrapheneContext grapheneContext = ((GrapheneProxyInstance)searchContext).getGrapheneContext();
        List result = (List)GrapheneProxy.getProxyForFutureTarget(grapheneContext, new GrapheneProxy.FutureTarget(){

            public Object getTarget() {
                List elements = searchContext.findElements(rootBy);
                ArrayList fragments = new ArrayList();
                for (int i = 0; i < elements.size(); ++i) {
                    fragments.add(PageFragmentEnricher.createPageFragment(clazz, WebElementUtils.findElementLazily(rootBy, searchContext, i)));
                }
                return fragments;
            }
        }, List.class, new Class[0]);
        return result;
    }

    public static <T> T createPageFragment(Class<T> clazz, WebElement root) {
        try {
            GrapheneContext grapheneContext = ((GrapheneProxyInstance)root).getGrapheneContext();
            Object pageFragment = null;
            if (Modifier.isFinal(clazz.getModifiers())) {
                throw new PageFragmentInitializationException("Page Fragment must not be final class. It is, your " + clazz + ", declared in: " + clazz);
            }
            Class<?> webElementInterface = PageFragmentEnricher.extractWebElementType(clazz);
            pageFragment = webElementInterface != null ? (Object)PageFragmentEnricher.createProxyDelegatingToRoot(root, clazz, webElementInterface) : (Object)PageFragmentEnricher.instantiate(clazz, new Object[0]);
            LinkedList<Field> roots = new LinkedList<Field>();
            roots.addAll(ReflectionHelper.getFieldsWithAnnotation(clazz, Root.class));
            if (roots.size() > 1) {
                throw new PageFragmentInitializationException("The Page Fragment " + NEW_LINE + pageFragment.getClass() + NEW_LINE + " can not have more than one field annotated with Root annotation!" + "Your fields with @Root annotation: " + roots + NEW_LINE);
            }
            if (roots.size() == 1) {
                PageFragmentEnricher.setValue((Field)roots.get(0), pageFragment, root);
            }
            PageFragmentEnricher.enrichRecursively((SearchContext)root, pageFragment);
            Object proxy = GrapheneProxy.getProxyForHandler(GrapheneContextualHandler.forTarget(grapheneContext, pageFragment), clazz, new Class[0]);
            PageFragmentEnricher.enrichRecursively((SearchContext)root, proxy);
            return proxy;
        }
        catch (NoSuchMethodException ex) {
            throw new PageFragmentInitializationException(" Check whether declared Page Fragment has no argument constructor!", ex);
        }
        catch (IllegalAccessException ex) {
            throw new PageFragmentInitializationException(" Check whether declared Page Fragment has public no argument constructor!", ex);
        }
        catch (InstantiationException ex) {
            throw new PageFragmentInitializationException(" Check whether you did not declare Page Fragment with abstract type!", ex);
        }
        catch (Exception ex) {
            throw new PageFragmentInitializationException(ex);
        }
    }

    private static Class<?> extractWebElementType(Class<?> clazz) {
        List<Class<?>> interfaces = Arrays.asList(clazz.getInterfaces());
        if (interfaces.contains(GrapheneElement.class)) {
            return GrapheneElement.class;
        }
        if (interfaces.contains(WebElement.class)) {
            return WebElement.class;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (!Object.class.equals(superclass)) {
            return PageFragmentEnricher.extractWebElementType(superclass);
        }
        return null;
    }

    private static <T> T createProxyDelegatingToRoot(final WebElement root, Class<T> clazz, final Class<?> webElementType) {
        return ClassImposterizer.INSTANCE.imposterise(new MethodInterceptor(){

            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                List<Method> webElementMethods = Arrays.asList(webElementType.getMethods());
                if (webElementMethods.contains(method)) {
                    try {
                        return method.invoke((Object)root, args);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getCause();
                    }
                }
                return proxy.invokeSuper(obj, args);
            }
        }, clazz, webElementType);
    }

    protected final void setupPageFragmentList(SearchContext searchContext, Object target, Field field) throws ClassNotFoundException {
        GrapheneContext grapheneContext = ((GrapheneProxyInstance)searchContext).getGrapheneContext();
        By rootBy = FindByUtilities.getCorrectBy(field, ((GrapheneConfiguration)this.configuration.get()).getDefaultElementLocatingStrategy());
        List<?> pageFragments = this.createPageFragmentList(this.getListType(field), searchContext, rootBy);
        PageFragmentEnricher.setValue(field, target, pageFragments);
    }

    protected final void setupPageFragment(SearchContext searchContext, Object target, Field field) {
        GrapheneContext grapheneContext = ((GrapheneProxyInstance)searchContext).getGrapheneContext();
        By rootBy = FindByUtilities.getCorrectBy(field, ((GrapheneConfiguration)this.configuration.get()).getDefaultElementLocatingStrategy());
        WebElement root = WebElementUtils.findElementLazily(rootBy, searchContext);
        Object pageFragment = PageFragmentEnricher.createPageFragment(field.getType(), root);
        PageFragmentEnricher.setValue(field, target, pageFragment);
    }

    public int getPrecedence() {
        return 1;
    }
}

