/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene;

import java.util.EmptyStackException;
import java.util.Stack;
import org.jboss.arquillian.graphene.wait.WebDriverWait;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GrapheneRuntime {
    private static final ThreadLocal<Stack<GrapheneRuntime>> RUNTIMES_STACK = new ThreadLocal<Stack<GrapheneRuntime>>(){

        @Override
        public Stack<GrapheneRuntime> initialValue() {
            return new Stack<GrapheneRuntime>();
        }
    };

    public abstract <T> T guardHttp(T var1);

    public abstract <T> T guardNoRequest(T var1);

    public abstract <T> T guardAjax(T var1);

    public abstract <T> T waitForHttp(T var1);

    public abstract WebDriverWait<Void> waitAjax();

    public abstract WebDriverWait<Void> waitAjax(WebDriver var1);

    public abstract WebDriverWait<Void> waitGui();

    public abstract WebDriverWait<Void> waitGui(WebDriver var1);

    public abstract WebDriverWait<Void> waitModel();

    public abstract WebDriverWait<Void> waitModel(WebDriver var1);

    public abstract <T> T createPageFragment(Class<T> var1, WebElement var2);

    public abstract <T> T goTo(Class<T> var1);

    public abstract <T> T goTo(Class<T> var1, Class<?> var2);

    public static GrapheneRuntime getInstance() {
        try {
            return RUNTIMES_STACK.get().peek();
        }
        catch (EmptyStackException e) {
            throw new IllegalStateException("The Graphene runtime isn't initialized.");
        }
    }

    public static void pushInstance(GrapheneRuntime grapheneRuntime) {
        if (!RUNTIMES_STACK.get().isEmpty()) {
            throw new IllegalStateException("There can be only one Graphene instance at the moment");
        }
        RUNTIMES_STACK.get().push(grapheneRuntime);
    }

    public static GrapheneRuntime popInstance() {
        if (RUNTIMES_STACK.get().isEmpty()) {
            throw new IllegalStateException("There is no Graphene instance at the moment");
        }
        return RUNTIMES_STACK.get().pop();
    }
}

