/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.weld.embedded;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.metadata.FilterPredicate;
import org.jboss.weld.resources.spi.ResourceLoader;

final class Utils {
    private static final String BEANS_XML_REGEX = ".*/beans\\.xml";

    private Utils() {
    }

    static <T> T getBeanReference(BeanManager manager, Class<T> type) {
        Bean bean = manager.resolve(manager.getBeans(type, new Annotation[0]));
        return (T)manager.getReference(bean, type, manager.createCreationalContext(null));
    }

    public static String findArchiveId(Archive<?> archive) {
        return archive.getName();
    }

    public static Collection<URL> findBeansXml(Archive<?> archive) {
        Validate.notNull(archive, (String)"Archive must be specified");
        ArrayList<URL> beansXmls = new ArrayList<URL>();
        Map nestedArchives = archive.getContent(Filters.include((String)".*\\.jar|.*\\.war"));
        for (Map.Entry nestedArchiveEntry : nestedArchives.entrySet()) {
            if (!(((Node)nestedArchiveEntry.getValue()).getAsset() instanceof ArchiveAsset)) continue;
            ArchiveAsset nestedArchive = (ArchiveAsset)((Node)nestedArchiveEntry.getValue()).getAsset();
            Map classes = nestedArchive.getArchive().getContent(Filters.include((String)BEANS_XML_REGEX));
            for (final Map.Entry entry : classes.entrySet()) {
                try {
                    beansXmls.add(new URL(null, "archive://" + nestedArchive.getArchive().getName() + ((ArchivePath)entry.getKey()).get(), new URLStreamHandler(){

                        @Override
                        protected URLConnection openConnection(URL u) throws IOException {
                            return new URLConnection(u){

                                @Override
                                public void connect() throws IOException {
                                }

                                @Override
                                public InputStream getInputStream() throws IOException {
                                    return ((Node)entry.getValue()).getAsset().openStream();
                                }
                            };
                        }
                    }));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Map classes = archive.getContent(Filters.include((String)BEANS_XML_REGEX));
        for (final Map.Entry entry : classes.entrySet()) {
            try {
                beansXmls.add(new URL(null, "archive://" + ((ArchivePath)entry.getKey()).get(), new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL u) throws IOException {
                        return new URLConnection(u){

                            @Override
                            public void connect() throws IOException {
                            }

                            @Override
                            public InputStream getInputStream() throws IOException {
                                return ((Node)entry.getValue()).getAsset().openStream();
                            }
                        };
                    }
                }));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return beansXmls;
    }

    public static Collection<Class<?>> findBeanClasses(Archive<?> archive, ClassLoader classLoader, BeansXml beansXml, ResourceLoader resourceLoader) {
        Validate.notNull(archive, (String)"Archive must be specified");
        ArrayList beanClasses = new ArrayList();
        try {
            Map nestedArchives = archive.getContent(Filters.include((String)".*\\.jar|.*\\.war|.*\\.rar"));
            for (Map.Entry nestedArchiveEntry : nestedArchives.entrySet()) {
                ArchiveAsset nestedArchive;
                Map markerFiles;
                if (!(((Node)nestedArchiveEntry.getValue()).getAsset() instanceof ArchiveAsset) || (markerFiles = (nestedArchive = (ArchiveAsset)((Node)nestedArchiveEntry.getValue()).getAsset()).getArchive().getContent(Filters.include((String)BEANS_XML_REGEX))).isEmpty()) continue;
                beanClasses.addAll(Utils.filterClasses(nestedArchive.getArchive(), classLoader, beansXml, resourceLoader));
            }
            Map markerFiles = archive.getContent(Filters.include((String)BEANS_XML_REGEX));
            if (!markerFiles.isEmpty()) {
                beanClasses.addAll(Utils.filterClasses(archive, classLoader, beansXml, resourceLoader));
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load class from archive " + archive.getName(), e);
        }
        return beanClasses;
    }

    public static String findClassName(ArchivePath path) {
        String className = path.get();
        if ((className = className.replaceAll("/WEB-INF/classes/", "")).charAt(0) == '/') {
            className = className.substring(1);
        }
        className = className.replaceAll("\\.class", "");
        className = className.replaceAll("/", ".");
        return className;
    }

    private static Collection<Class<?>> filterClasses(Archive<?> archive, ClassLoader classLoader, BeansXml beansXml, ResourceLoader resourceLoader) throws ClassNotFoundException {
        ArrayList beanClasses = new ArrayList();
        Map classes = archive.getContent(Filters.include((String)".*\\.class"));
        for (Map.Entry classEntry : classes.entrySet()) {
            if (beansXml.getScanning().getExcludes().isEmpty()) {
                Class<?> loadedClass = classLoader.loadClass(Utils.findClassName((ArchivePath)classEntry.getKey()));
                beanClasses.add(loadedClass);
                continue;
            }
            boolean isExcluded = false;
            for (Metadata filterMetadata : beansXml.getScanning().getExcludes()) {
                FilterPredicate excludePredicate = new FilterPredicate(filterMetadata, resourceLoader);
                if (!excludePredicate.test(Utils.findClassName((ArchivePath)classEntry.getKey()))) continue;
                isExcluded = true;
                break;
            }
            if (isExcluded) continue;
            Class<?> loadedClass = classLoader.loadClass(Utils.findClassName((ArchivePath)classEntry.getKey()));
            beanClasses.add(loadedClass);
        }
        return beanClasses;
    }
}

