/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.client.deployment.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.impl.client.deployment.command.DeployDeploymentCommand;
import org.jboss.arquillian.container.test.impl.client.deployment.command.GetDeploymentCommand;
import org.jboss.arquillian.container.test.impl.client.deployment.command.UnDeployDeploymentCommand;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.EventContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentCommandObserver {
    private static final Logger log = Logger.getLogger(DeploymentCommandObserver.class.getName());
    @Inject
    private Instance<Deployer> deployerInst;

    static byte[] asByteArray(InputStream in) throws IllegalArgumentException {
        if (in == null) {
            throw new IllegalArgumentException("stream must be specified");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        int len = 4096;
        byte[] buffer = new byte[4096];
        int read = 0;
        try {
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error in obtainting bytes from " + in, ioe);
        }
        finally {
            block12: {
                try {
                    in.close();
                }
                catch (IOException ignore) {
                    if (!log.isLoggable(Level.FINER)) break block12;
                    log.finer("Could not close stream due to: " + ignore.getMessage() + "; ignoring");
                }
            }
        }
        byte[] content = out.toByteArray();
        return content;
    }

    public void onException(@Observes EventContext<Command> event) {
        try {
            event.proceed();
        }
        catch (Exception e) {
            ((Command)event.getEvent()).setResult((Object)("FAILED: " + e.getMessage()));
            ((Command)event.getEvent()).setThrowable((Throwable)e);
        }
    }

    public void deploy(@Observes DeployDeploymentCommand event) {
        ((Deployer)this.deployerInst.get()).deploy(event.getDeploymentName());
        event.setResult("SUCCESS");
    }

    public void undeploy(@Observes UnDeployDeploymentCommand event) {
        ((Deployer)this.deployerInst.get()).undeploy(event.getDeploymentName());
        event.setResult("SUCCESS");
    }

    public void getDeployment(@Observes GetDeploymentCommand event) {
        byte[] deploymentContent = DeploymentCommandObserver.asByteArray(((Deployer)this.deployerInst.get()).getDeployment(event.getDeploymentName()));
        event.setResult(deploymentContent);
    }
}

