/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut.ast;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassExpression {
    private String original;
    private Pattern classPattern;
    private boolean isAnnotation = false;
    private boolean isInstanceOf = false;
    private boolean isTypedef = false;
    private boolean isPackage = false;
    private boolean isInstanceOfAnnotated = false;

    public ClassExpression(String expr) {
        this.original = expr;
        if (expr.startsWith("@")) {
            this.isAnnotation = true;
        } else {
            expr = this.original;
            if (expr.startsWith("$instanceof{")) {
                this.isInstanceOf = true;
                expr = expr.substring(12, expr.lastIndexOf("}"));
                this.isInstanceOfAnnotated = expr.startsWith("@");
            } else if (expr.startsWith("$typedef{")) {
                this.isTypedef = true;
                expr = expr.substring(9, expr.lastIndexOf("}"));
            } else if (expr.endsWith("..")) {
                this.isPackage = true;
                expr = expr.substring(0, expr.lastIndexOf(".."));
            }
            if (!this.isAnnotation) {
                expr = expr.replaceAll("\\.", "\\\\.");
                expr = expr.replaceAll("\\*", ".*");
                expr = expr.replaceAll("\\[", "\\\\[");
                expr = expr.replaceAll("]", "\\\\]");
                expr = expr.replaceAll("\\$", "\\\\\\$");
                this.classPattern = Pattern.compile(expr);
            }
        }
    }

    public boolean isSimple() {
        return !this.isAnnotation && !this.isInstanceOf && !this.isTypedef && !this.isInstanceOfAnnotated;
    }

    public boolean matches(String classname) {
        if (this.isAnnotation) {
            return false;
        }
        if (this.isPackage()) {
            int index = classname.lastIndexOf(".");
            boolean matches = this.classPattern.toString().equals(".*");
            if (!matches && index != -1) {
                String candidate = classname.substring(0, index);
                Matcher m = this.classPattern.matcher(candidate);
                matches = m.matches();
            }
            return matches;
        }
        Matcher m = this.classPattern.matcher(classname);
        return m.matches();
    }

    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    public boolean isPackage() {
        return this.isPackage;
    }

    public boolean isInstanceOf() {
        return this.isInstanceOf;
    }

    public boolean isTypedef() {
        return this.isTypedef;
    }

    public boolean isInstanceOfAnnotated() {
        return this.isInstanceOfAnnotated;
    }

    public String getInstanceOfAnnotation() {
        if (!this.isInstanceOfAnnotated) {
            return null;
        }
        return this.original.substring(12, this.original.lastIndexOf("}"));
    }

    public String getOriginal() {
        return this.original;
    }

    public static String simpleType(Class<?> type) {
        Class<?> ret = type;
        if (ret.isArray()) {
            Class<?> arr = ret;
            String array = "";
            while (arr.isArray()) {
                array = array + "[]";
                arr = arr.getComponentType();
            }
            return arr.getName() + array;
        }
        return ret.getName();
    }
}

