/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.ant;

import java.io.File;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class AnnotationC
extends MatchingTask {
    private static String lSep = System.getProperty("line.separator");
    private Path classpath;
    private Path output;
    private Path compilerClasspath;
    private Path compileSourcepath;
    boolean xml = false;
    boolean bytecode = false;
    protected boolean failOnError = true;

    public void setXml(boolean i) {
        this.xml = i;
    }

    public boolean getXml() {
        return this.xml;
    }

    public void setBytecode(boolean i) {
        this.bytecode = i;
    }

    public boolean getBytecode() {
        return this.xml;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public void setClasspath(Path cp) {
        if (this.classpath == null) {
            this.classpath = cp;
        } else {
            this.classpath.append(cp);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public void setCompilerClasspathRef(Reference r) {
        if (this.compilerClasspath == null) {
            this.compilerClasspath = new Path(this.getProject());
        }
        this.compilerClasspath.setRefid(r);
    }

    public void setCompilerclasspath(Path cp) {
        if (this.compilerClasspath == null) {
            this.compilerClasspath = cp;
        } else {
            this.compilerClasspath.append(cp);
        }
    }

    public Path getCompilerclasspath() {
        return this.compilerClasspath;
    }

    public Path createCompilerclasspath() {
        if (this.compilerClasspath == null) {
            this.compilerClasspath = new Path(this.getProject());
        }
        return this.compilerClasspath.createPath();
    }

    public Path createSrc() {
        if (this.compileSourcepath == null) {
            this.compileSourcepath = new Path(this.getProject());
        }
        return this.compileSourcepath.createPath();
    }

    public Path createOutput() {
        if (this.output == null) {
            this.output = new Path(this.getProject());
        }
        return this.output.createPath();
    }

    public void setOutput(Path cp) {
        if (this.output == null) {
            this.output = cp;
        } else {
            this.output.append(cp);
        }
    }

    public Path getOutput() {
        return this.output;
    }

    public void execute() throws BuildException {
        CommandlineJava cmd = new CommandlineJava();
        if (this.output != null) {
            cmd.createArgument().setValue("-o");
            cmd.createArgument().setValue(this.output.toString());
        }
        if (this.xml) {
            cmd.createArgument().setValue("-xml");
        }
        if (this.bytecode) {
            cmd.createArgument().setValue("-bytecode");
        }
        this.logAndAddFilesToCompile(cmd);
        try {
            this.classpath.append(this.compilerClasspath);
            Java java = (Java)this.getProject().createTask("java");
            if (this.getClasspath() != null) {
                this.getProject().log("using user supplied classpath: " + this.getClasspath(), 4);
                java.setClasspath(this.getClasspath().concatSystemClasspath("ignore"));
            } else {
                Path classpath = new Path(this.getProject());
                classpath = classpath.concatSystemClasspath("only");
                this.getProject().log("using system classpath: " + classpath, 4);
                java.setClasspath(classpath);
            }
            java.setDir(this.getProject().getBaseDir());
            java.setClassname("org.jboss.aop.annotation.compiler.AnnotationCompiler");
            String[] args = cmd.getJavaCommand().getArguments();
            for (int i = 0; i < args.length; ++i) {
                java.createArg().setValue(args[i]);
            }
            java.setFailonerror(this.getFailonerror());
            java.setFork(false);
            java.setTaskName("annotationc");
            java.execute();
        }
        catch (Exception ex) {
            if (ex instanceof BuildException) {
                throw (BuildException)ex;
            }
            throw new BuildException("Error running aopc compiler: ", (Throwable)ex, this.getLocation());
        }
    }

    protected void logAndAddFilesToCompile(CommandlineJava cmd) {
        String[] list = this.compileSourcepath.list();
        ArrayList<String> compilingFiles = new ArrayList<String>();
        for (int i = 0; i < list.length; ++i) {
            File srcDir = this.getProject().resolveFile(list[i]);
            if (!srcDir.exists()) {
                throw new BuildException("srcdir \"" + srcDir.getPath() + "\" does not exist!", this.getLocation());
            }
            DirectoryScanner ds = this.getDirectoryScanner(srcDir);
            String[] files = ds.getIncludedFiles();
            for (int j = 0; j < files.length; ++j) {
                if (!files[j].endsWith(".java")) continue;
                File f = new File(srcDir, files[j]);
                compilingFiles.add(f.getAbsolutePath());
            }
        }
        StringBuffer niceSourceList = new StringBuffer("File");
        for (int i = 0; i < compilingFiles.size(); ++i) {
            String file = (String)compilingFiles.get(i);
            cmd.createArgument().setValue(file);
            niceSourceList.append("    " + file + lSep);
        }
    }
}

