/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ConstructorInfo;
import org.jboss.aop.DynamicAOPStrategy;
import org.jboss.aop.FieldInfo;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.InterceptorChainObserver;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.MethodInterceptors;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.DynamicTransformationObserver;
import org.jboss.aop.instrument.HotSwapper;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.InstrumentorFactory;
import org.jboss.aop.instrument.JoinpointClassifier;
import org.jboss.aop.instrument.JoinpointFullClassifier;
import org.jboss.aop.instrument.JoinpointStatusUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HotSwapStrategy
implements DynamicAOPStrategy {
    private HotSwapper hotSwapper;
    private Collection<JoinpointStatusUpdate> joinpointUpdates;
    private Instrumentor instrumentor;

    public HotSwapStrategy(HotSwapper hotSwapper) {
        this.hotSwapper = hotSwapper;
        this.joinpointUpdates = new ArrayList<JoinpointStatusUpdate>();
        this.instrumentor = InstrumentorFactory.getInstrumentor(AspectManager.instance(), this.getJoinpointClassifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void interceptorChainsUpdated() {
        Collection<JoinpointStatusUpdate> collection = this.joinpointUpdates;
        synchronized (collection) {
            if (!this.joinpointUpdates.isEmpty()) {
                this.instrumentor.interceptorChainsUpdated(new ArrayList<JoinpointStatusUpdate>(this.joinpointUpdates), this.hotSwapper);
                this.joinpointUpdates.clear();
            }
        }
    }

    @Override
    public JoinpointClassifier getJoinpointClassifier() {
        return new JoinpointFullClassifier();
    }

    @Override
    public DynamicTransformationObserver getDynamicTransformationObserver(CtClass clazz) {
        return new DynamicTransformationTracker(clazz);
    }

    @Override
    public InterceptorChainObserver getInterceptorChainObserver(Class<?> clazz) {
        ClassPool classPool = AspectManager.instance().findClassPool(clazz);
        CtClass ctClass = null;
        try {
            ctClass = classPool.get(clazz.getName());
        }
        catch (NotFoundException e) {
            throw new RuntimeException("Class " + clazz.getName() + " was not found at class pool.");
        }
        return new JoinpointStatusUpdater(ctClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void newJoinpointUpdate(JoinpointStatusUpdate update) {
        Collection<JoinpointStatusUpdate> collection = this.joinpointUpdates;
        synchronized (collection) {
            this.joinpointUpdates.add(update);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinpointStatusUpdater
    implements InterceptorChainObserver {
        private JoinpointStatusUpdate.ClassJoinpoints newlyAdvised;
        private JoinpointStatusUpdate.ClassJoinpoints newlyUnadvised;
        private int instanceInterceptors;
        private WeakHashMap<InstanceAdvisor, Integer> instanceAdvisors;
        private CtClass clazz;
        private int fields;
        private int constructors;
        private int methods;
        private Interceptor[][] fieldReadInterceptors;
        private Interceptor[][] fieldWriteInterceptors;
        private Interceptor[][] constructorInterceptors;
        private Map<MethodInfo, Interceptor[]> methodInterceptors;
        private int[] constructorIndexMap;

        public JoinpointStatusUpdater(CtClass clazz) {
            this.clazz = clazz;
            this.instanceAdvisors = new WeakHashMap();
        }

        @Override
        public synchronized void initialInterceptorChains(final Class<?> reflectionClass, FieldInfo[] fieldReadInfos, FieldInfo[] fieldWriteInfos, ConstructorInfo[] constructorInfos, MethodInterceptors methodInterceptors) {
            Constructor<?>[] declaredConstructors = null;
            if (System.getSecurityManager() == null) {
                declaredConstructors = reflectionClass.getDeclaredConstructors();
            } else {
                try {
                    declaredConstructors = AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<?>[]>(){

                        @Override
                        public Constructor<?>[] run() throws Exception {
                            return reflectionClass.getDeclaredConstructors();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException("Error retrieving declared constructors of " + reflectionClass.getName(), e.getException());
                }
            }
            this.constructorIndexMap = new int[declaredConstructors.length];
            int javassistIndex = 0;
            for (int reflectionIndex = 0; reflectionIndex < declaredConstructors.length; ++reflectionIndex) {
                Class<?>[] params = declaredConstructors[reflectionIndex].getParameterTypes();
                this.constructorIndexMap[reflectionIndex] = params.length > 0 && params[params.length - 1].getName().equals("javassist.runtime.Inner") ? -1 : javassistIndex++;
            }
            this.fieldReadInterceptors = this.copyInterceptorChains(fieldReadInfos);
            this.fieldWriteInterceptors = this.copyInterceptorChains(fieldWriteInfos);
            this.constructorInterceptors = this.copyInterceptorChains(constructorInfos);
            this.methodInterceptors = new HashMap<MethodInfo, Interceptor[]>();
            long[] methodKeys = methodInterceptors.keys();
            for (int i = 0; i < methodKeys.length; ++i) {
                long key = methodKeys[i];
                MethodInfo methodInfo = methodInterceptors.getMethodInfo(key);
                this.methodInterceptors.put(methodInfo, methodInfo.getInterceptors());
            }
            this.fields = fieldReadInfos.length;
            this.constructors = constructorInfos.length;
            this.methods = methodInterceptors.size();
            this.newlyAdvised = new JoinpointStatusUpdate.ClassJoinpoints(this.fields, this.constructors, this.methods);
            this.newlyUnadvised = new JoinpointStatusUpdate.ClassJoinpoints(this.fields, this.constructors, this.methods);
        }

        @Override
        public synchronized void interceptorChainsUpdated(FieldInfo[] newFieldReadInfos, FieldInfo[] newFieldWriteInfos, ConstructorInfo[] newConstructorInfos, MethodInterceptors newMethodInterceptors) {
            long key;
            int i;
            long[] methodKeys;
            if (this.instanceInterceptors == 0) {
                methodKeys = newMethodInterceptors.keys();
                for (i = 0; i < methodKeys.length; ++i) {
                    key = methodKeys[i];
                    MethodInfo newMethodInfo = newMethodInterceptors.getMethodInfo(key);
                    Interceptor[] oldInterceptorChain = this.methodInterceptors.get(newMethodInfo);
                    if (!(oldInterceptorChain != null && oldInterceptorChain.length != 0 || newMethodInfo.getInterceptorChain().isEmpty())) {
                        this.newlyAdvised.methodExecutions.add(newMethodInfo);
                        continue;
                    }
                    if (oldInterceptorChain == null || oldInterceptorChain.length <= 0 || !newMethodInfo.getInterceptorChain().isEmpty()) continue;
                    this.newlyUnadvised.methodExecutions.add(newMethodInfo);
                }
                this.fillNewStateCollections(this.fieldReadInterceptors, newFieldReadInfos, this.newlyAdvised.fieldReads, this.newlyUnadvised.fieldReads, null);
                this.fillNewStateCollections(this.fieldWriteInterceptors, newFieldWriteInfos, this.newlyAdvised.fieldWrites, this.newlyUnadvised.fieldWrites, null);
                this.fillNewStateCollections(this.constructorInterceptors, newConstructorInfos, this.newlyAdvised.constructorExecutions, this.newlyUnadvised.constructorExecutions, this.constructorIndexMap);
                HotSwapStrategy.this.newJoinpointUpdate(this.getJoinpointStatusUpdate());
            }
            this.fieldReadInterceptors = this.copyInterceptorChains(newFieldReadInfos);
            this.fieldWriteInterceptors = this.copyInterceptorChains(newFieldWriteInfos);
            this.constructorInterceptors = this.copyInterceptorChains(newConstructorInfos);
            methodKeys = newMethodInterceptors.keys();
            for (i = 0; i < methodKeys.length; ++i) {
                key = methodKeys[i];
                MethodInfo methodInfo = newMethodInterceptors.getMethodInfo(key);
                this.methodInterceptors.put(methodInfo, methodInfo.getInterceptors());
            }
        }

        @Override
        public synchronized void instanceInterceptorAdded(InstanceAdvisor instanceAdvisor) {
            this.instanceInterceptorsAdded(instanceAdvisor, 1);
        }

        @Override
        public synchronized void instanceInterceptorsAdded(InstanceAdvisor instanceAdvisor, int howMany) {
            this.updateInstanceInterceptorsTable(instanceAdvisor, howMany);
            this.updateAdvisenessStatus(this.newlyAdvised);
            this.instanceInterceptors += howMany;
            HotSwapStrategy.this.interceptorChainsUpdated();
        }

        @Override
        public synchronized void instanceInterceptorRemoved(InstanceAdvisor instanceAdvisor) {
            this.instanceInterceptorsRemoved(instanceAdvisor, 1);
        }

        @Override
        public synchronized void instanceInterceptorsRemoved(InstanceAdvisor instanceAdvisor, int howMany) {
            this.updateInstanceInterceptorsTable(instanceAdvisor, -howMany);
            this.instanceInterceptors -= howMany;
            this.updateAdvisenessStatus(this.newlyUnadvised);
            HotSwapStrategy.this.interceptorChainsUpdated();
        }

        @Override
        public synchronized void allInstanceInterceptorsRemoved(InstanceAdvisor instanceAdvisor) {
            if (this.instanceAdvisors.containsKey(instanceAdvisor)) {
                this.instanceAdvisors.remove(instanceAdvisor);
            }
            if (this.instanceInterceptors == 0) {
                return;
            }
            this.instanceInterceptors = 0;
            for (Integer interceptors : this.instanceAdvisors.values()) {
                this.instanceInterceptors += interceptors.intValue();
            }
            if (this.instanceInterceptors > 0) {
                return;
            }
            this.updateAdvisenessStatus(this.newlyUnadvised);
            HotSwapStrategy.this.interceptorChainsUpdated();
        }

        private Interceptor[][] copyInterceptorChains(JoinPointInfo[] updatedInfos) {
            Interceptor[][] copy = new Interceptor[updatedInfos.length][];
            for (int i = 0; i < updatedInfos.length; ++i) {
                copy[i] = updatedInfos[i].getInterceptors();
            }
            return copy;
        }

        private JoinpointStatusUpdate getJoinpointStatusUpdate() {
            JoinpointStatusUpdate update = new JoinpointStatusUpdate();
            update.clazz = this.clazz;
            update.newlyAdvisedJoinpoints = this.newlyAdvised;
            update.newlyUnadvisedJoinpoints = this.newlyUnadvised;
            this.newlyAdvised = new JoinpointStatusUpdate.ClassJoinpoints(this.fields, this.constructors, this.methods);
            this.newlyUnadvised = new JoinpointStatusUpdate.ClassJoinpoints(this.fields, this.constructors, this.methods);
            return update;
        }

        private void fillNewStateCollections(Interceptor[][] interceptors, JoinPointInfo[] updatedInfos, Collection<Integer> newlyAdvised, Collection<Integer> newlyUnadvised, int[] indexMap) {
            if (this.instanceInterceptors > 0) {
                return;
            }
            for (int i = 0; i < interceptors.length; ++i) {
                boolean interceptedNow;
                Interceptor[] oldInterceptorsChain = interceptors[i];
                Interceptor[] newInterceptorsChain = updatedInfos[i].getInterceptors();
                boolean interceptedBefore = oldInterceptorsChain != null && oldInterceptorsChain.length > 0;
                boolean bl = interceptedNow = newInterceptorsChain != null && newInterceptorsChain.length > 0;
                if (!interceptedBefore && interceptedNow) {
                    if (indexMap != null) {
                        if (indexMap[i] == -1) continue;
                        newlyAdvised.add(new Integer(indexMap[i]));
                        continue;
                    }
                    newlyAdvised.add(new Integer(i));
                    continue;
                }
                if (!interceptedBefore || interceptedNow) continue;
                if (indexMap != null) {
                    if (indexMap[i] == -1) continue;
                    newlyUnadvised.add(new Integer(indexMap[i]));
                    continue;
                }
                newlyUnadvised.add(new Integer(i));
            }
        }

        private void updateInstanceInterceptorsTable(InstanceAdvisor instanceAdvisor, int interceptorsAdded) {
            if (this.instanceAdvisors.containsKey(instanceAdvisor)) {
                Integer interceptors = this.instanceAdvisors.get(instanceAdvisor);
                this.instanceAdvisors.put(instanceAdvisor, new Integer(interceptors + interceptorsAdded));
            } else {
                this.instanceAdvisors.put(instanceAdvisor, new Integer(interceptorsAdded));
            }
        }

        private void updateAdvisenessStatus(JoinpointStatusUpdate.ClassJoinpoints joinpoints) {
            if (this.instanceInterceptors == 0) {
                for (Map.Entry<MethodInfo, Interceptor[]> entry : this.methodInterceptors.entrySet()) {
                    if (entry.getValue() != null && entry.getValue().length != 0) continue;
                    joinpoints.methodExecutions.add(entry.getKey());
                }
                this.findUnadvisedJoinpoints(this.fieldReadInterceptors, joinpoints.fieldReads);
                this.findUnadvisedJoinpoints(this.fieldWriteInterceptors, joinpoints.fieldWrites);
                this.findUnadvisedJoinpoints(this.constructorInterceptors, joinpoints.constructorExecutions);
                HotSwapStrategy.this.newJoinpointUpdate(this.getJoinpointStatusUpdate());
            }
        }

        private void findUnadvisedJoinpoints(Interceptor[][] interceptors, Collection<Integer> joinpointsFound) {
            for (int i = 0; i < interceptors.length; ++i) {
                if (interceptors[i] != null && interceptors[i].length != 0) continue;
                joinpointsFound.add(new Integer(i));
            }
        }
    }

    private class DynamicTransformationTracker
    implements DynamicTransformationObserver {
        private Collection<CtField> fieldReads = new ArrayList<CtField>();
        private Collection<CtField> fieldWrites = new ArrayList<CtField>();
        private boolean constructor = false;

        public DynamicTransformationTracker(CtClass clazz) {
        }

        public void fieldReadDynamicalyWrapped(CtField field) {
            this.fieldReads.add(field);
        }

        public void fieldWriteDynamicalyWrapped(CtField field) {
            this.fieldWrites.add(field);
        }

        public void constructorDynamicalyWrapped() {
            this.constructor = true;
        }

        public void transformationFinished(CtClass clazz, CodeConverter converter) {
            if (this.constructor || !this.fieldReads.isEmpty() || !this.fieldWrites.isEmpty()) {
                HotSwapStrategy.this.instrumentor.convertProcessedClasses(HotSwapStrategy.this.hotSwapper, clazz, this.fieldReads, this.fieldWrites, this.constructor);
            }
        }
    }
}

