/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.batch.api.BatchProperty;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jberet.support.io.ItemReaderWriterBase;
import org.jberet.support.io.MappingJsonFactoryObjectFactory;
import org.jberet.support.io.NoMappingJsonFactoryObjectFactory;

public abstract class JsonItemReaderWriterBase
extends ItemReaderWriterBase {
    @Inject
    @BatchProperty
    protected String jsonFactoryFeatures;
    @Inject
    @BatchProperty
    protected String mapperFeatures;
    @Inject
    @BatchProperty
    protected String jsonFactoryLookup;
    protected JsonFactory jsonFactory;
    protected ObjectMapper objectMapper;

    protected abstract void registerModule() throws Exception;

    protected void initJsonFactoryAndObjectMapper() throws NamingException {
        this.jsonFactory = this.jsonFactoryLookup != null ? (JsonFactory)InitialContext.doLookup(this.jsonFactoryLookup) : new MappingJsonFactory();
        this.objectMapper = (ObjectMapper)this.jsonFactory.getCodec();
        if (this.jsonFactoryFeatures != null) {
            NoMappingJsonFactoryObjectFactory.configureJsonFactoryFeatures(this.jsonFactory, this.jsonFactoryFeatures);
        }
        if (this.mapperFeatures != null) {
            MappingJsonFactoryObjectFactory.configureMapperFeatures(this.objectMapper, this.mapperFeatures);
        }
    }
}

