/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.batch.api.BatchProperty;
import javax.inject.Inject;
import org.jberet.support._private.SupportLogger;
import org.jberet.support.io.UnicodeBOMInputStream;

public abstract class ItemReaderWriterBase {
    protected static final String NEW_LINE = System.getProperty("line.separator");
    @Inject
    @BatchProperty
    protected String resource;
    boolean skipWritingHeader;

    protected InputStream getInputStream(boolean detectBOM) {
        InputStream inputStream;
        if (this.resource == null) {
            throw SupportLogger.LOGGER.invalidReaderWriterProperty(null, null, "resource");
        }
        try {
            try {
                URL url = new URL(this.resource);
                inputStream = url.openStream();
            }
            catch (MalformedURLException e) {
                SupportLogger.LOGGER.tracef("The resource %s is not a URL, %s%n", this.resource, e);
                File file = new File(this.resource);
                if (file.exists()) {
                    inputStream = new FileInputStream(file);
                }
                SupportLogger.LOGGER.tracef("The resource %s is not a file %n", this.resource);
                inputStream = ItemReaderWriterBase.class.getClassLoader().getResourceAsStream(this.resource);
            }
            if (detectBOM) {
                UnicodeBOMInputStream bomin = new UnicodeBOMInputStream(inputStream);
                bomin.skipBOM();
                return bomin;
            }
        }
        catch (IOException e) {
            throw SupportLogger.LOGGER.failToOpenStream(e, this.resource);
        }
        return inputStream;
    }

    protected OutputStream getOutputStream(String writeMode) {
        if (this.resource == null) {
            throw SupportLogger.LOGGER.invalidReaderWriterProperty(null, null, "resource");
        }
        try {
            File file = new File(this.resource);
            boolean exists = file.exists();
            if (writeMode == null || writeMode.equalsIgnoreCase("append")) {
                FileOutputStream fos = new FileOutputStream(file, true);
                if (file.length() > 0L) {
                    this.skipWritingHeader = true;
                    fos.write(NEW_LINE.getBytes());
                }
                return fos;
            }
            if (writeMode.equalsIgnoreCase("overwrite")) {
                return new FileOutputStream(file);
            }
            if (writeMode.equalsIgnoreCase("failIfExists")) {
                if (exists) {
                    throw SupportLogger.LOGGER.writerResourceAlreadyExists(file.getPath());
                }
                return new FileOutputStream(file);
            }
            throw SupportLogger.LOGGER.invalidReaderWriterProperty(null, writeMode, "writeMode");
        }
        catch (IOException e) {
            throw SupportLogger.LOGGER.invalidReaderWriterProperty(e, this.resource, "resource");
        }
    }
}

