/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.test;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.javalite.activejdbc.DB;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.connection_config.ConnectionConfig;
import org.javalite.activejdbc.connection_config.DBConfiguration;
import org.javalite.test.jspec.JSpecSupport;
import org.junit.After;
import org.junit.Before;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBSpec
extends DBConfiguration
implements JSpecSupport {
    private static Logger LOGGER = LoggerFactory.getLogger(DBSpec.class);
    private boolean rollback = true;
    private boolean suppressDb = false;
    private List<ConnectionConfig> testConnectionConfigs;

    public boolean suppressedDb() {
        return this.suppressDb;
    }

    public void suppressDb(boolean suppressDb) {
        this.suppressDb = suppressDb;
    }

    public boolean rollback() {
        return this.rollback;
    }

    public void setRollback(boolean rollback) {
        if (!this.suppressDb) {
            this.rollback = rollback;
            Map<String, Connection> connections = DB.connections();
            for (String name : connections.keySet()) {
                try {
                    boolean autocommit = !rollback;
                    connections.get(name).setAutoCommit(autocommit);
                }
                catch (SQLException e) {
                    throw new InitException(e);
                }
            }
        }
    }

    @Before
    @BeforeEach
    public final void openTestConnections() {
        if (!this.suppressDb) {
            DBSpec.loadConfiguration("/database.properties");
            this.testConnectionConfigs = this.getTestConnectionConfigs();
            if (this.testConnectionConfigs.isEmpty()) {
                LOGGER.warn("no DB connections are configured, none opened");
            } else {
                this.testConnectionConfigs.forEach(connectionConfig -> {
                    DB db = new DB(connectionConfig.getDbName());
                    db.open((ConnectionConfig)connectionConfig);
                    if (this.rollback) {
                        db.openTransaction();
                    }
                });
            }
        }
    }

    @After
    @AfterEach
    public final void closeTestConnections() {
        if (!this.suppressDb) {
            for (ConnectionConfig connectionConfig : this.testConnectionConfigs) {
                String dbName = connectionConfig.getDbName();
                DB db = new DB(dbName);
                if (this.rollback) {
                    db.rollbackTransaction();
                }
                db.close();
            }
            DBSpec.clearConnectionConfigs();
        }
    }
}

