/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.cache;

import java.net.URL;
import java.util.HashSet;
import org.ehcache.Cache;
import org.ehcache.config.Configuration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.xml.XmlConfiguration;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.cache.CacheEvent;
import org.javalite.activejdbc.cache.CacheManager;
import org.javalite.activejdbc.cache.EHCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EHCache3Manager
extends CacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EHCacheManager.class);
    private final CacheConfigurationBuilder<String, Object> cacheTemplate;
    private final Object lock = new Object();
    private HashSet<String> groups = new HashSet();
    private org.ehcache.CacheManager cacheManager;

    public EHCache3Manager() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        URL url = this.getClass().getResource("/activejdbc-ehcache.xml");
        if (url == null) {
            throw new InitException("You are using " + this.getClass().getName() + " but failed to provide a EHCache configuration file on classpath: activejdbc-ehcache.xml");
        }
        XmlConfiguration xmlConfiguration = new XmlConfiguration(url);
        this.cacheTemplate = xmlConfiguration.newCacheConfigurationBuilderFromTemplate("activejdbc", String.class, Object.class);
        if (this.cacheTemplate == null) {
            throw new InitException("Please, provide a <cache-template name=\"activejdbc\"> element in  activejdbc-ehcache.xml file");
        }
        this.cacheManager = CacheManagerBuilder.newCacheManager((Configuration)xmlConfiguration);
        this.cacheManager.init();
    }

    @Override
    public Object getCache(String group, String key) {
        try {
            Cache<String, Object> c = this.getCacheForGroupOrCreateIt(group);
            return c.get((Object)key);
        }
        catch (Exception e) {
            LOGGER.warn("{}", (Object)e, (Object)e);
            return null;
        }
    }

    @Override
    public void addCache(String group, String key, Object cache) {
        this.getCacheForGroupOrCreateIt(group).put((Object)key, cache);
    }

    @Override
    public void doFlush(CacheEvent event) {
        if (event.getType().equals((Object)CacheEvent.CacheEventType.ALL)) {
            this.purgeAllGroups();
        } else if (event.getType().equals((Object)CacheEvent.CacheEventType.GROUP)) {
            this.purgeGroup(event.getGroup());
        }
    }

    private void purgeGroup(String group) {
        Cache cache = this.cacheManager.getCache(group, String.class, Object.class);
        if (cache != null) {
            cache.clear();
        }
    }

    private void purgeAllGroups() {
        for (String group : this.groups) {
            this.purgeGroup(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<String, Object> getCacheForGroupOrCreateIt(String group) {
        Cache cache = this.cacheManager.getCache(group, String.class, Object.class);
        if (cache == null) {
            Object object = this.lock;
            synchronized (object) {
                cache = this.cacheManager.getCache(group, String.class, Object.class);
                if (cache == null) {
                    cache = this.cacheManager.createCache(group, this.cacheTemplate);
                    this.groups.add(group);
                }
            }
        }
        return cache;
    }

    @Override
    public Object getImplementation() {
        return this.cacheManager;
    }
}

