/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javalite.activejdbc.ColumnMetadata;
import org.javalite.activejdbc.Configuration;
import org.javalite.activejdbc.ConnectionsAccess;
import org.javalite.activejdbc.DBException;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.MetaModels;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.ModelFinder;
import org.javalite.activejdbc.ModelRegistry;
import org.javalite.activejdbc.annotations.BelongsTo;
import org.javalite.activejdbc.annotations.BelongsToParents;
import org.javalite.activejdbc.annotations.BelongsToPolymorphic;
import org.javalite.activejdbc.annotations.HasManies;
import org.javalite.activejdbc.annotations.HasMany;
import org.javalite.activejdbc.annotations.Many2Manies;
import org.javalite.activejdbc.annotations.Many2Many;
import org.javalite.activejdbc.annotations.UnrelatedTo;
import org.javalite.activejdbc.associations.BelongsToAssociation;
import org.javalite.activejdbc.associations.BelongsToPolymorphicAssociation;
import org.javalite.activejdbc.associations.Many2ManyAssociation;
import org.javalite.activejdbc.associations.OneToManyAssociation;
import org.javalite.activejdbc.associations.OneToManyPolymorphicAssociation;
import org.javalite.activejdbc.cache.CacheManager;
import org.javalite.activejdbc.cache.QueryCache;
import org.javalite.activejdbc.logging.LogFilter;
import org.javalite.activejdbc.logging.LogLevel;
import org.javalite.activejdbc.statistics.StatisticsQueue;
import org.javalite.common.CaseInsensitiveMap;
import org.javalite.common.Inflector;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Registry {
    INSTANCE;

    private static final Logger LOGGER;
    private static final int STATIC_METADATA_CHECKED = 1;
    private static final int STATIC_METADATA_LOADED = 2;
    private final MetaModels metaModels = new MetaModels();
    private final Configuration configuration = new Configuration();
    private final StatisticsQueue statisticsQueue;
    private final Set<String> initedDbs = new HashSet<String>();
    private int staticMetadataStatus = 0;
    private String modelFile = "activejdbc_models.properties";

    private Registry() {
        this.statisticsQueue = this.configuration.collectStatistics() ? new StatisticsQueue(this.configuration.collectStatisticsOnHold()) : null;
    }

    public static Registry instance() {
        return INSTANCE;
    }

    public StatisticsQueue getStatisticsQueue() {
        if (this.statisticsQueue == null) {
            throw new InitException("cannot collect statistics if this was not configured in activejdbc.properties file. Add 'collectStatistics = true' to it.");
        }
        return this.statisticsQueue;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public static CacheManager cacheManager() {
        return QueryCache.instance().getCacheManager();
    }

    public MetaModel getMetaModel(String table) {
        return this.metaModels.getMetaModel(table);
    }

    public MetaModel getMetaModel(Class<? extends Model> modelClass) {
        String dbName = MetaModel.getDbName(modelClass);
        this.init(dbName);
        return this.metaModels.getMetaModel(modelClass);
    }

    ModelRegistry modelRegistryOf(Class<? extends Model> modelClass) {
        return this.metaModels.getModelRegistry(modelClass);
    }

    synchronized void init(String dbName) {
        if (this.staticMetadataStatus == 2 || this.initedDbs.contains(dbName)) {
            return;
        }
        this.initedDbs.add(dbName);
        if (this.staticMetadataStatus != 1 && this.loadStaticMetadata()) {
            return;
        }
        try {
            String[] tables;
            Connection c = ConnectionsAccess.getConnection(dbName);
            if (c == null) {
                throw new DBException("Failed to retrieve metadata from DB, connection: '" + dbName + "' is not available");
            }
            DatabaseMetaData databaseMetaData = c.getMetaData();
            String dbType = c.getMetaData().getDatabaseProductName();
            Set<Class<? extends Model>> modelClasses = ModelFinder.getModelsForDb(dbName);
            this.registerModels(dbName, modelClasses, dbType);
            for (String table : tables = this.metaModels.getTableNames(dbName)) {
                Map<String, ColumnMetadata> metaParams = this.fetchMetaParams(databaseMetaData, dbType, table);
                this.registerColumnMetadata(table, metaParams);
            }
            for (String table : tables) {
                this.discoverAssociationsFor(table, dbName);
            }
            this.processOverrides(modelClasses);
        }
        catch (Exception e) {
            this.initedDbs.remove(dbName);
            if (e instanceof InitException) {
                throw (InitException)e;
            }
            if (e instanceof DBException) {
                throw (DBException)e;
            }
            throw new InitException(e);
        }
    }

    private boolean loadStaticMetadata() {
        try {
            Enumeration<URL> urls = ((Object)((Object)Registry.instance())).getClass().getClassLoader().getResources("activejdbc_metadata.json");
            int n = this.staticMetadataStatus = urls.hasMoreElements() ? 2 : 1;
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                LogFilter.log(LOGGER, LogLevel.INFO, "Loading metadata from: {}", (Object)url.toExternalForm());
                this.metaModels.fromJSON(Util.read((InputStream)url.openStream()));
            }
            return this.staticMetadataStatus == 2;
        }
        catch (IOException e) {
            throw new InitException(e);
        }
    }

    protected String metadataToJSON() {
        return this.metaModels.toJSON();
    }

    private String getConnectionSchema(DatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return databaseMetaData.getConnection().getSchema();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getConnectionCatalog(DatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return databaseMetaData.getConnection().getCatalog();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String mangleTableName(String tableName, String dbType) {
        if (dbType.toLowerCase().contains("h2")) {
            if (!tableName.contains("\"")) {
                tableName = tableName.toUpperCase();
            } else if (tableName.startsWith("\"") && tableName.endsWith("\"")) {
                tableName = tableName.substring(1, tableName.length() - 1);
            }
        } else if (dbType.toLowerCase().contains("postgres") && tableName.startsWith("\"") && tableName.endsWith("\"")) {
            tableName = tableName.substring(1, tableName.length() - 1);
        }
        return tableName;
    }

    private Map<String, ColumnMetadata> fetchMetaParams(DatabaseMetaData databaseMetaData, String dbType, String table) throws SQLException {
        String[] parts = table.split("\\.", 3);
        String schema = null;
        String tableName = null;
        switch (parts.length) {
            case 1: {
                schema = this.getConnectionSchema(databaseMetaData);
                tableName = parts[0];
                break;
            }
            case 2: {
                schema = parts[0];
                tableName = parts[1];
            }
        }
        if (Util.blank(tableName) || schema != null && schema.trim().length() == 0) {
            throw new DBException("invalid table name : " + table);
        }
        String catalog = this.getConnectionCatalog(databaseMetaData);
        tableName = this.mangleTableName(tableName, dbType);
        ResultSet rs = databaseMetaData.getColumns(catalog, schema, tableName, null);
        Map<String, ColumnMetadata> columns = this.getColumns(rs, dbType);
        rs.close();
        if (columns.isEmpty()) {
            rs = databaseMetaData.getColumns(catalog, schema, tableName.toUpperCase(), null);
            columns = this.getColumns(rs, dbType);
            rs.close();
        }
        if (columns.isEmpty()) {
            rs = databaseMetaData.getColumns(catalog, schema, tableName.toLowerCase(), null);
            columns = this.getColumns(rs, dbType);
            rs.close();
        }
        if (columns.size() > 0) {
            LogFilter.log(LOGGER, LogLevel.INFO, "Fetched metadata for table: {}", (Object)table);
        } else {
            LogFilter.log(LOGGER, LogLevel.WARNING, "Failed to retrieve metadata for table: '{}'. Are you sure this table exists? For some databases table names are case sensitive.", (Object)table);
        }
        return columns;
    }

    private void registerModels(String dbName, Set<Class<? extends Model>> modelClasses, String dbType) {
        for (Class<? extends Model> modelClass : modelClasses) {
            MetaModel mm = new MetaModel(dbName, modelClass, dbType);
            this.metaModels.addMetaModel(mm, modelClass);
            LogFilter.log(LOGGER, LogLevel.INFO, "Registered model: {}", modelClass);
        }
    }

    private void processOverrides(Set<Class<? extends Model>> models) {
        for (Class<? extends Model> modelClass : models) {
            UnrelatedTo unrelatedTo;
            BelongsToPolymorphic belongsToPolymorphic;
            Many2Many many2manyAnnotation;
            HasManies hasManiesAnnotation;
            BelongsTo belongsToAnnotation = modelClass.getAnnotation(BelongsTo.class);
            this.processOverridesBelongsTo(modelClass, belongsToAnnotation);
            BelongsToParents belongsToParentAnnotation = modelClass.getAnnotation(BelongsToParents.class);
            if (belongsToParentAnnotation != null) {
                for (BelongsTo belongsTo : belongsToParentAnnotation.value()) {
                    this.processOverridesBelongsTo(modelClass, belongsTo);
                }
            }
            if ((hasManiesAnnotation = modelClass.getAnnotation(HasManies.class)) != null) {
                for (HasMany hasMany : hasManiesAnnotation.value()) {
                    this.processOverridesHasMany(modelClass, hasMany);
                }
            }
            HasMany hasManyAnnotation = modelClass.getAnnotation(HasMany.class);
            this.processOverridesHasMany(modelClass, hasManyAnnotation);
            Many2Manies many2ManiesAnnotation = modelClass.getAnnotation(Many2Manies.class);
            if (many2ManiesAnnotation != null) {
                for (Many2Many many2Many : many2ManiesAnnotation.value()) {
                    this.processManyToManyOverrides(many2Many, modelClass);
                }
            }
            if ((many2manyAnnotation = modelClass.getAnnotation(Many2Many.class)) != null) {
                this.processManyToManyOverrides(many2manyAnnotation, modelClass);
            }
            if ((belongsToPolymorphic = modelClass.getAnnotation(BelongsToPolymorphic.class)) != null) {
                this.processPolymorphic(belongsToPolymorphic, modelClass);
            }
            if ((unrelatedTo = modelClass.getAnnotation(UnrelatedTo.class)) == null) continue;
            this.processUnrelatedTo(unrelatedTo, modelClass);
        }
    }

    private void processUnrelatedTo(UnrelatedTo unrelatedTo, Class<? extends Model> modelClass) {
        Class<? extends Model>[] related;
        for (Class<? extends Model> relatedClass : related = unrelatedTo.value()) {
            Object association;
            MetaModel relatedMM = this.metaModels.getMetaModel(relatedClass);
            MetaModel thisMM = this.metaModels.getMetaModel(modelClass);
            if (relatedMM != null) {
                association = relatedMM.getAssociationForTarget(modelClass);
                relatedMM.removeAssociationForTarget(modelClass);
                if (association != null) {
                    LogFilter.log(LOGGER, LogLevel.INFO, "Removed association: " + association);
                }
            }
            association = thisMM.getAssociationForTarget(relatedClass);
            thisMM.removeAssociationForTarget(relatedClass);
            if (association == null) continue;
            LogFilter.log(LOGGER, LogLevel.INFO, "Removed association: " + association);
        }
    }

    private void processPolymorphic(BelongsToPolymorphic belongsToPolymorphic, Class<? extends Model> modelClass) {
        Class<? extends Model>[] parentClasses = belongsToPolymorphic.parents();
        String[] typeLabels = belongsToPolymorphic.typeLabels();
        if (typeLabels.length > 0 && typeLabels.length != parentClasses.length) {
            throw new InitException("must provide all type labels for polymorphic associations");
        }
        int parentClassesLength = parentClasses.length;
        for (int i = 0; i < parentClassesLength; ++i) {
            Class<? extends Model> parentClass = parentClasses[i];
            String typeLabel = typeLabels.length > 0 ? typeLabels[i] : parentClass.getName();
            BelongsToPolymorphicAssociation belongsToPolymorphicAssociation = new BelongsToPolymorphicAssociation(modelClass, parentClass, typeLabel, parentClass.getName());
            this.metaModels.getMetaModel(modelClass).addAssociation(belongsToPolymorphicAssociation);
            OneToManyPolymorphicAssociation oneToManyPolymorphicAssociation = new OneToManyPolymorphicAssociation(parentClass, modelClass, typeLabel);
            this.metaModels.getMetaModel(parentClass).addAssociation(oneToManyPolymorphicAssociation);
        }
    }

    private void processManyToManyOverrides(Many2Many many2manyAnnotation, Class<? extends Model> modelClass) {
        String otherPk;
        String thisPk;
        Class<? extends Model> otherClass = many2manyAnnotation.other();
        String source = this.metaModels.getTableName(modelClass);
        String target = this.metaModels.getTableName(otherClass);
        String join = many2manyAnnotation.join();
        String sourceFKName = many2manyAnnotation.sourceFKName();
        String targetFKName = many2manyAnnotation.targetFKName();
        try {
            Method m = modelClass.getMethod("getMetaModel", new Class[0]);
            MetaModel mm = (MetaModel)m.invoke(modelClass, new Object[0]);
            thisPk = mm.getIdName();
            m = otherClass.getMethod("getMetaModel", new Class[0]);
            mm = (MetaModel)m.invoke(otherClass, new Object[0]);
            otherPk = mm.getIdName();
        }
        catch (Exception e) {
            throw new InitException("failed to determine PK name in many to many relationship", e);
        }
        Many2ManyAssociation many2many1 = new Many2ManyAssociation(modelClass, otherClass, join, sourceFKName, targetFKName, otherPk);
        this.metaModels.getMetaModel(source).addAssociation(many2many1);
        Many2ManyAssociation many2many2 = new Many2ManyAssociation(otherClass, modelClass, join, targetFKName, sourceFKName, thisPk);
        this.metaModels.getMetaModel(target).addAssociation(many2many2);
    }

    private void processOverridesBelongsTo(Class<? extends Model> modelClass, BelongsTo belongsToAnnotation) {
        if (belongsToAnnotation != null) {
            Class<? extends Model> parentClass = belongsToAnnotation.parent();
            String foreignKeyName = belongsToAnnotation.foreignKeyName();
            if (this.metaModels.getMetaModel(parentClass).hasAssociation(modelClass, OneToManyAssociation.class)) {
                LogFilter.log(LOGGER, LogLevel.WARNING, "Redundant annotations used: @BelongsTo and @HasMany on a relationship between Model {} and Model {}.", (Object)modelClass.getName(), (Object)parentClass.getName());
                return;
            }
            OneToManyAssociation hasMany = new OneToManyAssociation(parentClass, modelClass, foreignKeyName);
            BelongsToAssociation belongsTo = new BelongsToAssociation(modelClass, parentClass, foreignKeyName);
            this.metaModels.getMetaModel(parentClass).addAssociation(hasMany);
            this.metaModels.getMetaModel(modelClass).addAssociation(belongsTo);
        }
    }

    private void processOverridesHasMany(Class<? extends Model> modelClass, HasMany hasManyAnnotation) {
        if (hasManyAnnotation != null) {
            Class<? extends Model> childClass = hasManyAnnotation.child();
            String foreignKeyName = hasManyAnnotation.foreignKeyName();
            if (this.metaModels.getMetaModel(childClass).hasAssociation(modelClass, OneToManyAssociation.class)) {
                LogFilter.log(LOGGER, LogLevel.WARNING, "Redundant annotations used: @BelongsTo and @HasMany on a relationship between Model {} and Model {}.", (Object)modelClass.getName(), (Object)childClass.getName());
                return;
            }
            OneToManyAssociation hasMany = new OneToManyAssociation(modelClass, childClass, foreignKeyName);
            BelongsToAssociation belongsTo = new BelongsToAssociation(childClass, modelClass, foreignKeyName);
            this.metaModels.getMetaModel(modelClass).addAssociation(hasMany);
            this.metaModels.getMetaModel(childClass).addAssociation(belongsTo);
        }
    }

    private Map<String, ColumnMetadata> getColumns(ResultSet rs, String dbType) throws SQLException {
        CaseInsensitiveMap columns = new CaseInsensitiveMap();
        while (rs.next()) {
            if ("h2".equalsIgnoreCase(dbType) && "INFORMATION_SCHEMA".equals(rs.getString("TABLE_SCHEM"))) continue;
            ColumnMetadata cm = new ColumnMetadata(rs.getString("COLUMN_NAME"), rs.getString("TYPE_NAME"), rs.getInt("COLUMN_SIZE"));
            columns.put(cm.getColumnName(), cm);
        }
        return columns;
    }

    private void discoverAssociationsFor(String source, String dbName) {
        this.discoverOne2ManyAssociationsFor(source, dbName);
        this.discoverMany2ManyAssociationsFor(source, dbName);
    }

    private void discoverMany2ManyAssociationsFor(String source, String dbName) {
        for (String potentialJoinTable : this.metaModels.getTableNames(dbName)) {
            String target = Inflector.getOtherName((String)source, (String)potentialJoinTable);
            if (target == null || this.getMetaModel(target) == null || !this.hasForeignKeys(potentialJoinTable, source, target)) continue;
            Class<? extends Model> sourceModelClass = this.metaModels.getModelClass(source);
            Class<? extends Model> targetModelClass = this.metaModels.getModelClass(target);
            Many2ManyAssociation associationSource = new Many2ManyAssociation(sourceModelClass, targetModelClass, potentialJoinTable, this.getMetaModel(source).getFKName(), this.getMetaModel(target).getFKName());
            this.getMetaModel(source).addAssociation(associationSource);
        }
    }

    private boolean hasForeignKeys(String join, String source, String other) {
        String sourceFKName = this.getMetaModel(source).getFKName();
        String otherFKName = this.getMetaModel(other).getFKName();
        MetaModel joinMM = this.getMetaModel(join);
        return joinMM.hasAttribute(sourceFKName) && joinMM.hasAttribute(otherFKName);
    }

    private void discoverOne2ManyAssociationsFor(String source, String dbName) {
        MetaModel sourceMM = this.getMetaModel(source);
        for (String target : this.metaModels.getTableNames(dbName)) {
            MetaModel targetMM = this.getMetaModel(target);
            String sourceFKName = this.getMetaModel(source).getFKName();
            if (targetMM == sourceMM || !targetMM.hasAttribute(sourceFKName)) continue;
            Class<? extends Model> sourceModelClass = this.metaModels.getModelClass(source);
            Class<? extends Model> targetModelClass = this.metaModels.getModelClass(target);
            targetMM.addAssociation(new BelongsToAssociation(targetModelClass, sourceModelClass, sourceFKName));
            sourceMM.addAssociation(new OneToManyAssociation(sourceModelClass, targetModelClass, sourceFKName));
        }
    }

    protected Class<? extends Model> getModelClass(String table, boolean suppressException) {
        Class<? extends Model> modelClass = this.metaModels.getModelClass(table);
        if (modelClass == null && !suppressException) {
            throw new InitException("failed to locate meta model for: " + table + ", are you sure this is correct table name?");
        }
        return modelClass;
    }

    protected String getTableName(Class<? extends Model> modelClass) {
        this.init(MetaModel.getDbName(modelClass));
        String tableName = this.metaModels.getTableName(modelClass);
        if (tableName == null) {
            throw new DBException("failed to find metamodel for " + modelClass + ". Are you sure that a corresponding table  exists in DB?");
        }
        return tableName;
    }

    protected List<String> getEdges(String join) {
        return this.metaModels.getEdges(join);
    }

    private void registerColumnMetadata(String table, Map<String, ColumnMetadata> metaParams) {
        this.metaModels.setColumnMetadata(table, metaParams);
    }

    public String getModelFile() {
        return this.modelFile;
    }

    public void setModelFile(String modelFile) {
        this.modelFile = modelFile;
    }

    static {
        LOGGER = LoggerFactory.getLogger(Registry.class);
    }
}

