/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.commands;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import org.jacoco.cli.internal.Command;
import org.jacoco.core.runtime.AgentOptions;
import org.jacoco.core.tools.ExecDumpClient;
import org.jacoco.core.tools.ExecFileLoader;
import org.kohsuke.args4j.Option;

public class Dump
extends Command {
    @Option(name="--address", usage="host name or ip address to connect to (default localhost)", metaVar="<address>")
    String address = AgentOptions.DEFAULT_ADDRESS;
    @Option(name="--port", usage="the port to connect to (default 6300)", metaVar="<port>")
    int port = 6300;
    @Option(name="--destfile", usage="file to write execution data to", metaVar="<path>", required=true)
    File destfile;
    @Option(name="--reset", usage="reset execution data on test target after dump")
    boolean reset = false;
    @Option(name="--retry", usage="number of retries (default 10)", metaVar="<count>")
    int retrycount = 10;

    public String description() {
        return "Request execution data from a JaCoCo agent running in 'tcpserver' output mode.";
    }

    public int execute(final PrintWriter out, final PrintWriter err) throws Exception {
        ExecDumpClient client = new ExecDumpClient(){

            protected void onConnecting(InetAddress address, int port) {
                out.printf("[INFO] Connecting to %s:%s.%n", address, port);
            }

            protected void onConnectionFailure(IOException exception) {
                err.printf("[WARN] %s.%n", exception.getMessage());
            }
        };
        client.setReset(this.reset);
        client.setRetryCount(this.retrycount);
        ExecFileLoader loader = client.dump(this.address, this.port);
        out.printf("[INFO] Writing execution data to %s.%n", this.destfile.getAbsolutePath());
        loader.save(this.destfile, true);
        return 0;
    }
}

