/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.utils.thread;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.iota.jota.utils.thread.ReportingExecutorService;
import org.iota.jota.utils.thread.SilentScheduledExecutorService;
import org.iota.jota.utils.thread.TaskDetails;

public class BoundedScheduledExecutorService
implements SilentScheduledExecutorService,
ReportingExecutorService {
    private final int capacity;
    private final ScheduledExecutorService delegate;
    private final Set<TaskDetails> scheduledTasks = ConcurrentHashMap.newKeySet();
    private AtomicInteger scheduledTasksCounter = new AtomicInteger(0);

    public BoundedScheduledExecutorService(int capacity) {
        this.capacity = capacity;
        this.delegate = Executors.newScheduledThreadPool(capacity);
    }

    @Override
    public void onScheduleTask(TaskDetails taskDetails) {
        this.scheduledTasks.add(taskDetails);
    }

    @Override
    public void onStartTask(TaskDetails taskDetails) {
    }

    @Override
    public void onFinishTask(TaskDetails taskDetails, Throwable error) {
    }

    @Override
    public void onCancelTask(TaskDetails taskDetails) {
    }

    @Override
    public void onCompleteTask(TaskDetails taskDetails, Throwable error) {
        this.scheduledTasks.remove(taskDetails);
        this.scheduledTasksCounter.decrementAndGet();
    }

    @Override
    public ScheduledFuture<?> silentSchedule(Runnable task, long delay, TimeUnit unit) {
        return this.reserveCapacity(1) ? this.wrapScheduledFuture((Runnable wrappedTask) -> this.delegate.schedule((Runnable)wrappedTask, delay, unit), task, new TaskDetails().setDelay(delay).setTimeUnit(unit)) : null;
    }

    @Override
    public <V> ScheduledFuture<V> silentSchedule(Callable<V> task, long delay, TimeUnit unit) {
        return this.reserveCapacity(1) ? this.wrapScheduledFuture((Callable<V> wrappedTask) -> this.delegate.schedule(wrappedTask, delay, unit), task, new TaskDetails().setDelay(delay).setTimeUnit(unit)) : null;
    }

    @Override
    public ScheduledFuture<?> silentScheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return this.reserveCapacity(1) ? this.wrapScheduledFuture((Runnable wrappedTask) -> this.delegate.scheduleAtFixedRate((Runnable)wrappedTask, initialDelay, period, unit), task, new TaskDetails().setDelay(initialDelay).setInterval(period).setTimeUnit(unit)) : null;
    }

    @Override
    public ScheduledFuture<?> silentScheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        return this.reserveCapacity(1) ? this.wrapScheduledFuture((Runnable wrappedTask) -> this.delegate.scheduleWithFixedDelay((Runnable)wrappedTask, initialDelay, delay, unit), task, new TaskDetails().setDelay(initialDelay).setInterval(delay).setTimeUnit(unit)) : null;
    }

    @Override
    public <T> Future<T> silentSubmit(Callable<T> task) {
        return this.reserveCapacity(1) ? this.wrapFuture(this.delegate::submit, task, new TaskDetails()) : null;
    }

    @Override
    public Future<?> silentSubmit(Runnable task) {
        return this.reserveCapacity(1) ? this.wrapFuture(this.delegate::submit, task, new TaskDetails()) : null;
    }

    @Override
    public <T> Future<T> silentSubmit(Runnable task, T result) {
        return this.reserveCapacity(1) ? this.wrapFuture((Runnable wrappedTask) -> this.delegate.submit((Runnable)wrappedTask, result), task, new TaskDetails()) : null;
    }

    @Override
    public <T> List<Future<T>> silentInvokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.reserveCapacity(tasks.size()) ? this.delegate.invokeAll(this.wrapTasks(tasks, new TaskDetails())) : null;
    }

    @Override
    public <T> List<Future<T>> silentInvokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.reserveCapacity(tasks.size()) ? this.delegate.invokeAll(this.wrapTasks(tasks, new TaskDetails().setTimeout(timeout).setTimeUnit(unit)), timeout, unit) : null;
    }

    @Override
    public <T> T silentInvokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.reserveCapacity(tasks.size()) ? (T)this.delegate.invokeAny(this.wrapTasks(tasks, new TaskDetails())) : null;
    }

    @Override
    public <T> T silentInvokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.reserveCapacity(tasks.size()) ? (T)this.delegate.invokeAny(this.wrapTasks(tasks, new TaskDetails().setTimeout(timeout).setTimeUnit(unit)), timeout, unit) : null;
    }

    @Override
    public void silentExecute(Runnable task) {
        if (this.reserveCapacity(1)) {
            this.delegate.execute(this.wrapTask(task, new TaskDetails()));
        }
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.throwCapacityExhaustedIfNull(this.silentSchedule(command, delay, unit));
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.throwCapacityExhaustedIfNull(this.silentSchedule(callable, delay, unit));
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.throwCapacityExhaustedIfNull(this.silentScheduleAtFixedRate(command, initialDelay, period, unit));
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.throwCapacityExhaustedIfNull(this.silentScheduleWithFixedDelay(command, initialDelay, delay, unit));
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.throwCapacityExhaustedIfNull(this.silentSubmit(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.throwCapacityExhaustedIfNull(this.silentSubmit(task, result));
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.throwCapacityExhaustedIfNull(this.silentSubmit(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.throwCapacityExhaustedIfNull(this.silentInvokeAll(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.throwCapacityExhaustedIfNull(this.silentInvokeAll(tasks, timeout, unit));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.throwCapacityExhaustedIfNull(this.silentInvokeAny(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.throwCapacityExhaustedIfNull(this.silentInvokeAny(tasks, timeout, unit));
    }

    @Override
    public void execute(Runnable command) {
        if (!this.reserveCapacity(1)) {
            throw new RejectedExecutionException("the capacity is exhausted");
        }
        this.delegate.execute(this.wrapTask(command, new TaskDetails()));
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
        for (TaskDetails currentTask : this.scheduledTasks) {
            if (currentTask.getInterval() == null) continue;
            this.onCancelTask(currentTask);
            if (!currentTask.getScheduledForExecution().compareAndSet(true, false)) continue;
            this.onCompleteTask(currentTask, null);
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (!this.delegate.isShutdown()) {
            for (TaskDetails currentTask : this.scheduledTasks) {
                this.onCancelTask(currentTask);
                if (!currentTask.getScheduledForExecution().compareAndSet(true, false)) continue;
                this.onCompleteTask(currentTask, null);
            }
        }
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    private <V> Callable<V> wrapTask(Callable<V> task, TaskDetails taskDetails, Future<V> future) {
        this.onScheduleTask(taskDetails);
        return () -> {
            if (taskDetails.getScheduledForExecution().compareAndSet(true, false)) {
                Exception error = null;
                try {
                    this.onStartTask(taskDetails);
                    taskDetails.getExecutionCount().incrementAndGet();
                    Object v = task.call();
                    return v;
                }
                catch (Exception e) {
                    error = e;
                    throw e;
                }
                finally {
                    this.onFinishTask(taskDetails, error);
                    if (taskDetails.getInterval() == null || error != null || future == null || future.isCancelled() || this.delegate.isShutdown()) {
                        this.onCompleteTask(taskDetails, error);
                    } else {
                        taskDetails.getScheduledForExecution().set(true);
                    }
                }
            }
            return null;
        };
    }

    private <V> Callable<V> wrapTask(Callable<V> task, TaskDetails taskDetails) {
        return this.wrapTask(task, taskDetails, null);
    }

    private <V> Runnable wrapTask(Runnable task, TaskDetails taskDetails, Future<V> future) {
        this.onScheduleTask(taskDetails);
        return () -> {
            if (taskDetails.getScheduledForExecution().compareAndSet(true, false)) {
                Exception error = null;
                try {
                    this.onStartTask(taskDetails);
                    taskDetails.getExecutionCount().incrementAndGet();
                    task.run();
                }
                catch (Exception e) {
                    error = e;
                    throw e;
                }
                finally {
                    this.onFinishTask(taskDetails, error);
                    if (taskDetails.getInterval() == null || error != null || future == null || future.isCancelled() || this.delegate.isShutdown()) {
                        this.onCompleteTask(taskDetails, error);
                    } else {
                        taskDetails.getScheduledForExecution().set(true);
                    }
                }
            }
        };
    }

    private Runnable wrapTask(Runnable task, TaskDetails taskDetails) {
        return this.wrapTask(task, taskDetails, null);
    }

    private <V> Future<V> wrapFuture(FutureFactory<Future<V>, Callable<V>> futureFactory, Callable<V> task, TaskDetails taskDetails) {
        WrappedFuture<V> wrappedFuture = new WrappedFuture<V>(taskDetails);
        Callable<V> wrappedCallable = this.wrapTask(task, taskDetails, wrappedFuture);
        return wrappedFuture.delegate(futureFactory.create(wrappedCallable));
    }

    private <V> Future<V> wrapFuture(FutureFactory<Future<V>, Runnable> futureFactory, Runnable task, TaskDetails taskDetails) {
        WrappedFuture<V> wrappedFuture = new WrappedFuture<V>(taskDetails);
        Runnable wrappedTask = this.wrapTask(task, taskDetails, wrappedFuture);
        return wrappedFuture.delegate(futureFactory.create(wrappedTask));
    }

    private <V> ScheduledFuture<V> wrapScheduledFuture(FutureFactory<ScheduledFuture<V>, Callable<V>> futureFactory, Callable<V> task, TaskDetails taskDetails) {
        WrappedScheduledFuture<V> wrappedFuture = new WrappedScheduledFuture<V>(taskDetails);
        Callable<V> wrappedCallable = this.wrapTask(task, taskDetails, wrappedFuture);
        return wrappedFuture.delegate(futureFactory.create(wrappedCallable));
    }

    private <V> ScheduledFuture<V> wrapScheduledFuture(FutureFactory<ScheduledFuture<V>, Runnable> futureFactory, Runnable task, TaskDetails taskDetails) {
        WrappedScheduledFuture<V> wrappedFuture = new WrappedScheduledFuture<V>(taskDetails);
        Runnable wrappedRunnable = this.wrapTask(task, taskDetails, wrappedFuture);
        return wrappedFuture.delegate(futureFactory.create(wrappedRunnable));
    }

    private <T> Collection<? extends Callable<T>> wrapTasks(Collection<? extends Callable<T>> tasks, TaskDetails taskDetails) {
        ArrayList<Callable<T>> wrappedTasks = new ArrayList<Callable<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            wrappedTasks.add(this.wrapTask(task, taskDetails));
        }
        return wrappedTasks;
    }

    private boolean reserveCapacity(int requestedJobCount) {
        if (this.scheduledTasksCounter.addAndGet(requestedJobCount) <= this.capacity) {
            return true;
        }
        this.scheduledTasksCounter.addAndGet(-requestedJobCount);
        return false;
    }

    private <V> V throwCapacityExhaustedIfNull(V result) throws RejectedExecutionException {
        if (result == null) {
            throw new RejectedExecutionException("the capacity is exhausted");
        }
        return result;
    }

    private class WrappedScheduledFuture<V>
    extends WrappedFuture<V>
    implements ScheduledFuture<V> {
        private ScheduledFuture<V> delegate;

        private WrappedScheduledFuture(TaskDetails taskDetails) {
            super(taskDetails);
        }

        @Override
        public ScheduledFuture<V> delegate(ScheduledFuture<V> delegatedFuture) {
            this.delegate = delegatedFuture;
            return this;
        }

        @Override
        public ScheduledFuture<V> delegate() {
            return this.delegate;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.delegate().getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.delegate().compareTo(o);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!this.delegate().isCancelled() && !this.delegate().isDone()) {
                BoundedScheduledExecutorService.this.onCancelTask(this.taskDetails);
            }
            if (this.taskDetails.getScheduledForExecution().compareAndSet(true, false)) {
                BoundedScheduledExecutorService.this.onCompleteTask(this.taskDetails, null);
            }
            return this.delegate().cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate().isCancelled();
        }
    }

    private class WrappedFuture<V>
    implements Future<V> {
        protected final TaskDetails taskDetails;
        private Future<V> delegate;

        public WrappedFuture(TaskDetails taskDetails) {
            this.taskDetails = taskDetails;
        }

        public Future<V> delegate(Future<V> delegatedFuture) {
            this.delegate = delegatedFuture;
            return this;
        }

        public Future<V> delegate() {
            return this.delegate;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!this.delegate().isCancelled() && !this.delegate().isDone()) {
                BoundedScheduledExecutorService.this.onCancelTask(this.taskDetails);
            }
            if (this.taskDetails.getScheduledForExecution().compareAndSet(true, false)) {
                BoundedScheduledExecutorService.this.onCompleteTask(this.taskDetails, null);
            }
            return this.delegate().cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate().isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate().isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.delegate().get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate().get(timeout, unit);
        }
    }

    @FunctionalInterface
    private static interface FutureFactory<RESULT, ARGUMENT> {
        public RESULT create(ARGUMENT var1);
    }
}

