/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.types;

import java.io.Serializable;
import org.iota.jota.error.ArgumentException;
import org.iota.jota.utils.Checksum;
import org.iota.jota.utils.InputValidator;

public class Hash
implements Serializable {
    private static final long serialVersionUID = -5040410304130966841L;
    private String hash;
    private transient String hashCheckSum;

    private Hash() {
    }

    public Hash(String hash) throws ArgumentException {
        if (InputValidator.isAddress(hash)) {
            this.hashCheckSum = hash;
            this.hash = hash.substring(0, 81);
        } else {
            if (!InputValidator.isHash(hash)) {
                throw new ArgumentException("Invalid hash provided.");
            }
            this.hash = hash;
        }
    }

    public String getHash() {
        return this.hash;
    }

    public String getHashCheckSum() {
        if (null != this.hashCheckSum) {
            return this.hashCheckSum;
        }
        this.hashCheckSum = Checksum.addChecksum(this.hash);
        return this.hashCheckSum;
    }

    public String toString() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(Hash.class) && this.hash.equals(((Hash)obj).hash);
    }
}

