/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.connection;

import java.util.Map;
import java.util.Properties;
import org.iota.jota.connection.Connection;
import org.iota.jota.connection.ConnectionType;
import org.iota.jota.connection.HttpConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactory {
    private static final String KEY_TYPE = "type";
    private static final String KEY_NAME = "name";
    private static final String KEY_HOST = "host";
    private static final String KEY_URL = "url";
    private static final String KEY_PORT = "port";
    private static final String KEY_PROTOCOL = "protocol";
    private static final Logger log = LoggerFactory.getLogger(ConnectionFactory.class);

    public static Connection createConnection(Properties properties, int timeout) {
        if (!ConnectionFactory.preRequirements(properties)) {
            log.error("Configuration of node missing critical sections. Required: type, name and host");
            return null;
        }
        ConnectionType type = ConnectionType.byType(ConnectionFactory.propGetString(properties, KEY_TYPE));
        if (type == null) {
            log.error("Found unknown connection type. type, name and host");
            return null;
        }
        String host = ConnectionFactory.propGetString(properties, KEY_HOST);
        try {
            switch (type) {
                case HTTP: {
                    int port = Integer.parseInt(ConnectionFactory.propGetString(properties, KEY_PORT));
                    return new HttpConnector(ConnectionFactory.propGetString(properties, KEY_PROTOCOL), host, port, timeout);
                }
            }
        }
        catch (Exception e) {
            log.error("Failed making a connection due to " + e.getMessage());
        }
        log.error("Failed making a connection for node type " + (Object)((Object)type) + " at location " + host);
        return null;
    }

    public static Connection createConnection(Map<String, String> configValues, int timeout) {
        Properties properties = new Properties();
        properties.putAll(configValues);
        return ConnectionFactory.createConnection(properties, timeout);
    }

    private static String propGetString(Properties properties, String key) {
        Object o = properties.get(key);
        return o != null ? o.toString() : null;
    }

    private static boolean preRequirements(Properties configValues) {
        return !configValues.isEmpty() && (configValues.containsKey(KEY_TYPE) && configValues.containsKey(KEY_HOST) || configValues.contains(KEY_URL));
    }

    private ConnectionFactory() {
    }
}

