/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.account.plugins.transferchecker;

import java.util.ArrayList;
import java.util.List;
import org.iota.jota.IotaAPI;
import org.iota.jota.account.AccountStateManager;
import org.iota.jota.account.event.Event;
import org.iota.jota.account.event.EventManager;
import org.iota.jota.account.event.events.EventReceivedDeposit;
import org.iota.jota.account.event.events.EventReceivedMessage;
import org.iota.jota.account.event.events.EventReceivingDeposit;
import org.iota.jota.model.Bundle;
import org.iota.jota.model.Transaction;
import org.iota.jota.types.Address;
import org.iota.jota.utils.BundleValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncomingTransferCheckerTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(IncomingTransferCheckerTask.class);
    private Address address;
    private IotaAPI api;
    private List<String> receivingBundles;
    private List<String> receivedBundles;
    private List<String> invalidBundles;
    private boolean skipFirst;
    private EventManager eventManager;
    private AccountStateManager accountManager;

    public IncomingTransferCheckerTask(Address address, IotaAPI api, EventManager eventManager, boolean skipFirst, AccountStateManager accountManager) {
        this.address = address;
        this.api = api;
        this.eventManager = eventManager;
        this.skipFirst = skipFirst;
        this.receivingBundles = new ArrayList<String>();
        this.receivedBundles = new ArrayList<String>();
        this.invalidBundles = new ArrayList<String>();
        this.accountManager = accountManager;
    }

    @Override
    public void run() {
        block9: {
            String addrHash = this.address.getAddress().getHashCheckSum();
            try {
                Bundle[] bundles = this.api.bundlesFromAddresses(true, addrHash);
                if (bundles == null) {
                    return;
                }
                for (Bundle bundle : bundles) {
                    if (this.receivedBefore(bundle) || !this.isValid(bundle)) continue;
                    boolean isSpendFromOwnAddr = false;
                    boolean isTransferToOwnRemainderAddr = false;
                    for (Transaction t : bundle.getTransactions()) {
                        if (t.getValue() == 0L) continue;
                        boolean isOwn = this.accountManager.isOwnAddress(t.getAddress());
                        if (t.getValue() > 0L) {
                            isTransferToOwnRemainderAddr = isOwn;
                            continue;
                        }
                        isSpendFromOwnAddr = isOwn;
                    }
                    if (isTransferToOwnRemainderAddr || isSpendFromOwnAddr) {
                        this.receivedBundles.add(bundle.getBundleHash());
                        continue;
                    }
                    if (this.isValue(bundle)) {
                        if (!this.receivingBefore(bundle)) {
                            this.receivingBundles.add(bundle.getBundleHash());
                            this.emit(new EventReceivingDeposit(bundle, this.address));
                        }
                        if (!this.isConsistent(bundle)) continue;
                        this.receivedBundles.add(bundle.getBundleHash());
                        this.emit(new EventReceivedDeposit(bundle, this.address));
                        continue;
                    }
                    this.receivedBundles.add(bundle.getBundleHash());
                    this.emit(new EventReceivedMessage(bundle));
                }
                this.skipFirst = false;
            }
            catch (Exception e) {
                if (Thread.interrupted()) break block9;
                System.out.println("EHUGFSIF");
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean isValid(Bundle bundle) {
        if (this.invalidBundles.contains(bundle.getBundleHash())) {
            return true;
        }
        boolean valid = BundleValidator.isBundle(bundle);
        if (!valid) {
            this.invalidBundles.add(bundle.getBundleHash());
        }
        return valid;
    }

    private boolean isConsistent(Bundle bundle) {
        for (Transaction t : bundle.getTransactions()) {
            if (t.getPersistence().booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean receivedBefore(Bundle bundle) {
        return this.receivedBundles.contains(bundle.getBundleHash());
    }

    private boolean receivingBefore(Bundle bundle) {
        return this.receivingBundles.contains(bundle.getBundleHash());
    }

    private boolean isValue(Bundle bundle) {
        for (Transaction t : bundle.getTransactions()) {
            if (t.getValue() == 0L) continue;
            return true;
        }
        return false;
    }

    private void emit(Event event) {
        if (this.skipFirst) {
            return;
        }
        this.eventManager.emit(event);
    }
}

