/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.account.deposits.methods;

import java.util.ArrayList;
import java.util.List;
import org.iota.jota.account.deposits.ConditionalDepositAddress;
import org.iota.jota.account.deposits.methods.DepositMethod;
import org.iota.jota.account.deposits.methods.MagnetMethod;
import org.iota.jota.account.deposits.methods.QRMethod;

public class DepositFactory {
    private static DepositFactory instance = null;
    List<DepositMethod> methods = new ArrayList<DepositMethod>();

    public static DepositFactory get() {
        if (null == instance) {
            instance = new DepositFactory();
        }
        return instance;
    }

    private DepositFactory() {
        this.methods.add(new MagnetMethod());
        this.methods.add(new QRMethod());
    }

    public void addMethod(DepositMethod method) {
        this.methods.add(method);
    }

    public <T extends DepositMethod> Object build(ConditionalDepositAddress conditions, Class<T> methodType) {
        T method = this.getMethod(methodType);
        if (method == null) {
            return null;
        }
        return method.build(conditions);
    }

    public <T extends DepositMethod> ConditionalDepositAddress parse(Object conditions, Class<T> methodType) {
        Object method = this.getMethod(methodType);
        if (method == null) {
            return null;
        }
        return method.parse((Object)conditions);
    }

    private <T extends DepositMethod> T getMethod(Class<T> clazz) {
        for (DepositMethod m : this.methods) {
            if (!m.getClass().equals(clazz)) continue;
            return (T)m;
        }
        return null;
    }
}

