/*
 * Decompiled with CFR 0.152.
 */
package org.iota.jota.account;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.iota.jota.IotaAPI;
import org.iota.jota.account.AccountState;
import org.iota.jota.account.addressgenerator.AddressGeneratorService;
import org.iota.jota.account.deposits.DepositRequest;
import org.iota.jota.account.deposits.StoredDepositAddress;
import org.iota.jota.account.errors.AccountError;
import org.iota.jota.error.ArgumentException;
import org.iota.jota.model.Input;
import org.iota.jota.types.Address;
import org.iota.jota.types.Hash;

public class AccountBalanceCache {
    private Map<Input, DepositRequest> cachedIndexMap;
    private AddressGeneratorService addressGenerator;
    private AccountState state;
    private long totalBalance;

    public AccountBalanceCache(AddressGeneratorService addressGenerator, AccountState state, IotaAPI api) {
        this.addressGenerator = addressGenerator;
        this.state = state;
        this.totalBalance = 0L;
        this.recalcluate(api);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalcluate(IotaAPI api) {
        Map<Input, DepositRequest> map = this.cachedIndexMap = new ConcurrentHashMap<Input, DepositRequest>();
        synchronized (map) {
            for (Map.Entry<Integer, StoredDepositAddress> entry : this.state.getDepositRequests().entrySet()) {
                try {
                    this.calculateBalance(api, entry.getKey(), entry.getValue().getRequest(), entry.getValue().getSecurityLevel());
                }
                catch (ArgumentException e) {
                    throw new AccountError(e);
                }
            }
        }
    }

    private void calculateBalance(IotaAPI api, int index, DepositRequest request, int security) {
        Address address = this.addressGenerator.get(index);
        long balance = request.hasTimeOut() ? api.getBalance(address.getAddress().getHashCheckSum()) : request.getExpectedAmount();
        Input input = new Input(address.getAddress().getHashCheckSum(), balance, index, security);
        this.addInput(input, request);
    }

    private void addInput(Input input, DepositRequest balance) {
        this.cachedIndexMap.put(input, balance);
        this.totalBalance += balance.getExpectedAmount();
    }

    public Map.Entry<Input, DepositRequest> getByAddress(Address address) {
        return this.getByHash(address.getAddress());
    }

    public Map.Entry<Input, DepositRequest> getByHash(Hash hash) {
        return this.getByHash(hash.getHashCheckSum());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<Input, DepositRequest> getByHash(String hash) {
        Map<Input, DepositRequest> map = this.cachedIndexMap;
        synchronized (map) {
            for (Map.Entry<Input, DepositRequest> entry : this.cachedIndexMap.entrySet()) {
                if (!entry.getKey().getAddress().equals(hash)) continue;
                return entry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<Input, DepositRequest> getByIndex(int index) {
        Map<Input, DepositRequest> map = this.cachedIndexMap;
        synchronized (map) {
            for (Map.Entry<Input, DepositRequest> entry : this.cachedIndexMap.entrySet()) {
                if (entry.getKey().getKeyIndex() != index) continue;
                return entry;
            }
        }
        return null;
    }

    public Input first() {
        return this.cachedIndexMap.keySet().toArray(new Input[0])[0];
    }

    public Stream<Map.Entry<Input, DepositRequest>> getStream() {
        return this.cachedIndexMap.entrySet().stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBalance(Input input, DepositRequest depositRequest) {
        Map<Input, DepositRequest> map = this.cachedIndexMap;
        synchronized (map) {
            this.addInput(input, depositRequest);
        }
    }

    public long getTotalBalance() {
        return this.totalBalance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInput(Input input) {
        Map<Input, DepositRequest> map = this.cachedIndexMap;
        synchronized (map) {
            this.cachedIndexMap.remove(input);
            this.totalBalance -= input.getBalance();
        }
    }
}

