/*
 * Decompiled with CFR 0.152.
 */
package jota.utils;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class Converter {
    public static final int HIGH_INTEGER_BITS = -1;
    public static final long HIGH_LONG_BITS = -1L;
    private static final int RADIX = 3;
    private static final int MAX_TRIT_VALUE = 1;
    private static final int MIN_TRIT_VALUE = -1;
    private static final int NUMBER_OF_TRITS_IN_A_BYTE = 5;
    private static final int NUMBER_OF_TRITS_IN_A_TRYTE = 3;
    private static final int[][] BYTE_TO_TRITS_MAPPINGS;
    private static final int[][] TRYTE_TO_TRITS_MAPPINGS;

    public static byte[] bytes(int[] trits, int offset, int size) {
        byte[] bytes = new byte[(size + 5 - 1) / 5];
        for (int i = 0; i < bytes.length; ++i) {
            int j;
            int value = 0;
            int n = j = size - i * 5 < 5 ? size - i * 5 : 5;
            while (j-- > 0) {
                value = value * 3 + trits[offset + i * 5 + j];
            }
            bytes[i] = (byte)value;
        }
        return bytes;
    }

    public static byte[] bytes(int[] trits) {
        return Converter.bytes(trits, 0, trits.length);
    }

    public static void getTrits(byte[] bytes, int[] trits) {
        int offset = 0;
        for (int i = 0; i < bytes.length && offset < trits.length; offset += 5, ++i) {
            System.arraycopy(BYTE_TO_TRITS_MAPPINGS[bytes[i] < 0 ? bytes[i] + BYTE_TO_TRITS_MAPPINGS.length : bytes[i]], 0, trits, offset, trits.length - offset < 5 ? trits.length - offset : 5);
        }
        while (offset < trits.length) {
            trits[offset++] = 0;
        }
    }

    public static int[] convertToIntArray(List<Integer> integers) {
        int[] ret = new int[integers.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = integers.get(i);
        }
        return ret;
    }

    public static int[] trits(String trytes, int length) {
        int[] trits = Converter.trits(trytes);
        return Arrays.copyOf(trits, length);
    }

    public static int[] trits(long trytes, int length) {
        int[] trits = Converter.trits(trytes);
        return Arrays.copyOf(trits, length);
    }

    @Deprecated
    public static int[] tritsString(String trytes) {
        return Converter.trits(trytes);
    }

    public static int[] trits(long trytes) {
        LinkedList<Integer> trits = new LinkedList<Integer>();
        long absoluteValue = trytes < 0L ? -trytes : trytes;
        int position = 0;
        while (absoluteValue > 0L) {
            int remainder = (int)(absoluteValue % 3L);
            absoluteValue /= 3L;
            if (remainder > 1) {
                remainder = -1;
                ++absoluteValue;
            }
            trits.add(position++, remainder);
        }
        if (trytes < 0L) {
            for (int i = 0; i < trits.size(); ++i) {
                trits.set(i, -((Integer)trits.get(i)).intValue());
            }
        }
        return Converter.convertToIntArray(trits);
    }

    public static int[] trits(String trytes) {
        int[] d = new int[3 * trytes.length()];
        for (int i = 0; i < trytes.length(); ++i) {
            System.arraycopy(TRYTE_TO_TRITS_MAPPINGS["9ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(trytes.charAt(i))], 0, d, i * 3, 3);
        }
        return d;
    }

    public static int[] copyTrits(String input, int[] destination) {
        for (int i = 0; i < input.length(); ++i) {
            int index = "9ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(input.charAt(i));
            destination[i * 3] = TRYTE_TO_TRITS_MAPPINGS[index][0];
            destination[i * 3 + 1] = TRYTE_TO_TRITS_MAPPINGS[index][1];
            destination[i * 3 + 2] = TRYTE_TO_TRITS_MAPPINGS[index][2];
        }
        return destination;
    }

    public static String trytes(int[] trits, int offset, int size) {
        StringBuilder trytes = new StringBuilder();
        for (int i = 0; i < (size + 3 - 1) / 3; ++i) {
            int j = trits[offset + i * 3] + trits[offset + i * 3 + 1] * 3 + trits[offset + i * 3 + 2] * 9;
            if (j < 0) {
                j += "9ABCDEFGHIJKLMNOPQRSTUVWXYZ".length();
            }
            trytes.append("9ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(j));
        }
        return trytes.toString();
    }

    public static String trytes(int[] trits) {
        return Converter.trytes(trits, 0, trits.length);
    }

    public static int tryteValue(int[] trits, int offset) {
        return trits[offset] + trits[offset + 1] * 3 + trits[offset + 2] * 9;
    }

    public static int value(int[] trits) {
        int value = 0;
        int i = trits.length;
        while (i-- > 0) {
            value = value * 3 + trits[i];
        }
        return value;
    }

    public static int[] fromValue(int value) {
        int absoluteValue;
        if (0 == value) {
            return new int[]{0};
        }
        int[] destination = new int[(int)(1.0 + Math.floor(Math.log(2 * Math.max(1, Math.abs(value))) / Math.log(3.0)))];
        int i = 0;
        int n = absoluteValue = value < 0 ? -value : value;
        while (absoluteValue > 0) {
            int remainder = absoluteValue % 3;
            absoluteValue = (int)Math.floor(absoluteValue / 3);
            if (remainder > 1) {
                remainder = -1;
                ++absoluteValue;
            }
            destination[i] = remainder;
            ++i;
        }
        if (value < 0) {
            for (int j = 0; j < destination.length; ++j) {
                destination[j] = -destination[j];
            }
        }
        return destination;
    }

    public static long longValue(int[] trits) {
        long value = 0L;
        int i = trits.length;
        while (i-- > 0) {
            value = value * 3L + (long)trits[i];
        }
        return value;
    }

    public static void increment(int[] trits, int size) {
        for (int i = 0; i < size; ++i) {
            int n = i;
            trits[n] = trits[n] + 1;
            if (trits[n] <= 1) break;
            trits[i] = -1;
        }
    }

    static {
        int i;
        BYTE_TO_TRITS_MAPPINGS = new int[243][];
        TRYTE_TO_TRITS_MAPPINGS = new int[27][];
        int[] trits = new int[5];
        for (i = 0; i < 243; ++i) {
            Converter.BYTE_TO_TRITS_MAPPINGS[i] = Arrays.copyOf(trits, 5);
            Converter.increment(trits, 5);
        }
        for (i = 0; i < 27; ++i) {
            Converter.TRYTE_TO_TRITS_MAPPINGS[i] = Arrays.copyOf(trits, 3);
            Converter.increment(trits, 3);
        }
    }
}

