/*
 * Decompiled with CFR 0.152.
 */
package jota.utils;

import jota.error.ArgumentException;
import jota.pow.ICurl;
import jota.pow.SpongeFactory;
import jota.utils.Constants;
import jota.utils.Converter;
import jota.utils.InputValidator;

public class Checksum {
    public static String addChecksum(String address) throws ArgumentException {
        InputValidator.checkAddress(address);
        String addressWithChecksum = address;
        addressWithChecksum = addressWithChecksum + Checksum.calculateChecksum(address);
        return addressWithChecksum;
    }

    public static String removeChecksum(String address) throws ArgumentException {
        if (Checksum.isAddressWithChecksum(address)) {
            return Checksum.removeChecksumFromAddress(address);
        }
        if (Checksum.isAddressWithoutChecksum(address)) {
            return address;
        }
        throw new ArgumentException("Invalid addresses provided.");
    }

    private static String removeChecksumFromAddress(String addressWithChecksum) {
        return addressWithChecksum.substring(0, Constants.ADDRESS_LENGTH_WITHOUT_CHECKSUM);
    }

    public static boolean isValidChecksum(String addressWithChecksum) throws ArgumentException {
        String addressWithoutChecksum = Checksum.removeChecksum(addressWithChecksum);
        String addressWithRecalculateChecksum = addressWithoutChecksum = addressWithoutChecksum + Checksum.calculateChecksum(addressWithoutChecksum);
        return addressWithRecalculateChecksum.equals(addressWithChecksum);
    }

    public static boolean isAddressWithChecksum(String address) throws ArgumentException {
        return InputValidator.checkAddress(address) && address.length() == Constants.ADDRESS_LENGTH_WITH_CHECKSUM;
    }

    public static boolean isAddressWithoutChecksum(String address) throws ArgumentException {
        return InputValidator.checkAddress(address) && address.length() == Constants.ADDRESS_LENGTH_WITHOUT_CHECKSUM;
    }

    private static String calculateChecksum(String address) {
        ICurl curl = SpongeFactory.create(SpongeFactory.Mode.KERL);
        curl.reset();
        curl.absorb(Converter.trits(address));
        int[] checksumTrits = new int[243];
        curl.squeeze(checksumTrits);
        String checksum = Converter.trytes(checksumTrits);
        return checksum.substring(72, 81);
    }
}

