/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.junit.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <T> T newInstance(Class<T> klass) {
        return (T)org.instancio.internal.util.ReflectionUtils.newInstance(klass);
    }

    public static List<Annotation> collectionAnnotations(AnnotatedElement element) {
        Annotation[] annotations = element.getDeclaredAnnotations();
        ArrayList<Annotation> results = new ArrayList<Annotation>();
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> type = annotation.annotationType();
            if (type.getPackage().getName().startsWith("java.")) continue;
            results.add(annotation);
            results.addAll(ReflectionUtils.collectionAnnotations(type));
        }
        return results;
    }

    static List<Field> getAnnotatedFields(Class<?> klass, Class<? extends Annotation> annotation) {
        return Arrays.stream(klass.getDeclaredFields()).filter(field -> field.getAnnotation(annotation) != null).collect(Collectors.toList());
    }

    static Object getFieldValue(Field field, Object target) {
        try {
            field.setAccessible(true);
            return field.get(target);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static <T extends AccessibleObject> T setAccessible(T object) {
        return (T)org.instancio.internal.util.ReflectionUtils.setAccessible(object);
    }
}

