/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb.dto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Point;
import org.influxdb.impl.Preconditions;

public class BatchPoints {
    private String database;
    private String retentionPolicy;
    private Map<String, String> tags;
    private List<Point> points;
    private InfluxDB.ConsistencyLevel consistency;

    BatchPoints() {
    }

    public static Builder database(String database) {
        return new Builder(database);
    }

    public String getDatabase() {
        return this.database;
    }

    void setDatabase(String database) {
        this.database = database;
    }

    public String getRetentionPolicy() {
        return this.retentionPolicy;
    }

    void setRetentionPolicy(String retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    void setPoints(List<Point> points) {
        this.points = points;
    }

    public BatchPoints point(Point point) {
        point.getTags().putAll(this.tags);
        this.points.add(point);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public InfluxDB.ConsistencyLevel getConsistency() {
        return this.consistency;
    }

    void setConsistency(InfluxDB.ConsistencyLevel consistency) {
        this.consistency = consistency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchPoints that = (BatchPoints)o;
        return Objects.equals(this.database, that.database) && Objects.equals(this.retentionPolicy, that.retentionPolicy) && Objects.equals(this.tags, that.tags) && Objects.equals(this.points, that.points) && this.consistency == that.consistency;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.database, this.retentionPolicy, this.tags, this.points, this.consistency});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BatchPoints [database=");
        builder.append(this.database);
        builder.append(", retentionPolicy=");
        builder.append(this.retentionPolicy);
        builder.append(", consistency=");
        builder.append((Object)this.consistency);
        builder.append(", tags=");
        builder.append(this.tags);
        builder.append(", points=");
        builder.append(this.points);
        builder.append("]");
        return builder.toString();
    }

    public String lineProtocol() {
        StringBuilder sb = new StringBuilder();
        for (Point point : this.points) {
            sb.append(point.lineProtocol()).append("\n");
        }
        return sb.toString();
    }

    public static final class Builder {
        private final String database;
        private String retentionPolicy;
        private final Map<String, String> tags = new TreeMap<String, String>();
        private final List<Point> points = new ArrayList<Point>();
        private InfluxDB.ConsistencyLevel consistency;

        Builder(String database) {
            this.database = database;
        }

        public Builder retentionPolicy(String policy) {
            this.retentionPolicy = policy;
            return this;
        }

        public Builder tag(String tagName, String value) {
            this.tags.put(tagName, value);
            return this;
        }

        public Builder point(Point pointToAdd) {
            this.points.add(pointToAdd);
            return this;
        }

        public Builder points(Point ... pointsToAdd) {
            this.points.addAll(Arrays.asList(pointsToAdd));
            return this;
        }

        public Builder consistency(InfluxDB.ConsistencyLevel consistencyLevel) {
            this.consistency = consistencyLevel;
            return this;
        }

        public BatchPoints build() {
            Preconditions.checkNonEmptyString(this.database, "database");
            BatchPoints batchPoints = new BatchPoints();
            batchPoints.setDatabase(this.database);
            for (Point point : this.points) {
                point.getTags().putAll(this.tags);
            }
            batchPoints.setPoints(this.points);
            batchPoints.setRetentionPolicy(this.retentionPolicy);
            batchPoints.setTags(this.tags);
            if (null == this.consistency) {
                this.consistency = InfluxDB.ConsistencyLevel.ONE;
            }
            batchPoints.setConsistency(this.consistency);
            return batchPoints;
        }
    }
}

