/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.util.osgi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public final class ServiceLocator {
    public static final Long DEFAULT_TIMEOUT = 60000L;

    private ServiceLocator() {
    }

    public static <T> T getOsgiService(Class<T> type, long timeout) {
        return ServiceLocator.getOsgiService(type, null, timeout);
    }

    public static <T> T getOsgiService(Class<T> type) {
        return ServiceLocator.getOsgiService(type, null, DEFAULT_TIMEOUT);
    }

    public static <T> T getOsgiService(Class<T> type, String filter) {
        return ServiceLocator.getOsgiService(type, filter, DEFAULT_TIMEOUT);
    }

    public static <T> T getOsgiService(Class<T> type, String filter, long timeout) {
        BundleContext bundleContext = ServiceLocator.getBundleContext();
        ServiceTracker tracker = null;
        try {
            String flt = filter != null ? (filter.startsWith("(") ? "(&(objectClass=" + type.getName() + ")" + filter + ")" : "(&(objectClass=" + type.getName() + ")(" + filter + "))") : "(objectClass=" + type.getName() + ")";
            Filter osgiFilter = FrameworkUtil.createFilter((String)flt);
            tracker = new ServiceTracker(bundleContext, osgiFilter, null);
            tracker.open(true);
            T svc = type.cast(tracker.waitForService(timeout));
            if (svc == null) {
                Dictionary dic = bundleContext.getBundle().getHeaders();
                System.err.println("Test bundle headers: " + ServiceLocator.explode(dic));
                for (ServiceReference ref : ServiceLocator.asCollection(bundleContext.getAllServiceReferences(null, null))) {
                    System.err.println("ServiceReference: " + ref);
                }
                for (ServiceReference ref : ServiceLocator.asCollection(bundleContext.getAllServiceReferences(null, flt))) {
                    System.err.println("Filtered ServiceReference: " + ref);
                }
                throw new RuntimeException("Gave up waiting for service " + flt);
            }
            return type.cast(svc);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Invalid filter", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static BundleContext getBundleContext() {
        return FrameworkUtil.getBundle(ServiceLocator.class).getBundleContext();
    }

    private static String explode(Dictionary<String, String> dictionary) {
        Enumeration<String> keys = dictionary.keys();
        StringBuilder result = new StringBuilder();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            result.append(String.format("%s=%s", key, dictionary.get(key)));
            if (!keys.hasMoreElements()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    private static Collection<ServiceReference> asCollection(ServiceReference[] references) {
        return references != null ? Arrays.asList(references) : Collections.emptyList();
    }
}

