/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.util.arquillian.extensions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ServerKillProcessor;

public class InfinispanServerKillProcessor
implements ServerKillProcessor {
    private final Logger log = Logger.getLogger(InfinispanServerKillProcessor.class.getName());
    private static final long TIMEOUT = 1000L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void kill(Container container) throws Exception {
        String osName = System.getProperty("os.name", "");
        String killSequence = null;
        Process p = null;
        if (osName.startsWith("Linux")) {
            killSequence = "kill -9 `ps aux | grep -v 'grep' | grep 'jboss.home.dir=[jbossHome] ' | sed -re '1,$s/[ \\t]+/ /g' | cut -d ' ' -f 2`";
            killSequence = killSequence.replace("[jbossHome]", (CharSequence)container.getContainerConfiguration().getContainerProperties().get("jbossHome"));
            p = Runtime.getRuntime().exec(new String[]{"sh", "-c", killSequence});
            this.executeKill(p, killSequence);
            return;
        } else if (osName.startsWith("Mac OS X")) {
            killSequence = "ps aux | grep -v grep | grep 'jboss.home.dir=[jbossHome]' | awk '{ print $2 }' |xargs kill -9";
            killSequence = killSequence.replace("[jbossHome]", (CharSequence)container.getContainerConfiguration().getContainerProperties().get("jbossHome"));
            p = Runtime.getRuntime().exec(new String[]{"sh", "-c", killSequence});
            this.executeKill(p, killSequence);
            return;
        } else if (osName.startsWith("SunOS")) {
            killSequence = "jps | grep jboss-modules.jar | cut -f 1 -d ' ' | head -1 | xargs kill -9";
            p = Runtime.getRuntime().exec(new String[]{"sh", "-c", killSequence});
            this.executeKill(p, killSequence);
            return;
        } else if (osName.startsWith("HP-UX")) {
            String port = "8080";
            String vmArguments = (String)container.getContainerConfiguration().getContainerProperties().get("javaVmArguments");
            if (vmArguments.contains("jboss.node.name=node1")) {
                port = "8180";
            }
            if (vmArguments.contains("jboss.node.name=node2")) {
                port = "8280";
            }
            killSequence = "lsof | grep '" + port + " (LISTEN)' | awk '{print $2}' | xargs kill -9";
            p = Runtime.getRuntime().exec(new String[]{"sh", "-c", killSequence});
            this.executeKill(p, killSequence);
            return;
        } else {
            if (!osName.startsWith("Windows")) throw new RuntimeException("System was probably NOT properly decided. Property os.name = " + System.getProperty("os.name"));
            String port = "8080";
            String vmArguments = (String)container.getContainerConfiguration().getContainerProperties().get("javaVmArguments");
            if (vmArguments.contains("jboss.node.name=node1")) {
                port = "8180";
            }
            if (vmArguments.contains("jboss.node.name=node2")) {
                port = "8280";
            }
            Process ptemp = Runtime.getRuntime().exec(new String[]{"cmd", "/c", "netstat -aon | findstr LISTENING | findstr 127.0.0.1:" + port});
            ptemp.waitFor();
            this.log.info("Exit value of finding process (0 = ok, else num. unexpected): " + ptemp.exitValue());
            if (ptemp.exitValue() != 0) throw new RuntimeException("Finding sequence failed => server not killed. (Exit value of finding process: " + p.exitValue() + " OS=" + System.getProperty("os.name") + ")");
            String idForKill = this.getPidForKill(ptemp.getInputStream());
            this.log.info("Process ID for kill: " + idForKill + " (port: " + port + ")");
            killSequence = "taskkill /F /T /PID " + idForKill;
            p = Runtime.getRuntime().exec(new String[]{"cmd", "/c", killSequence});
            this.executeKill(p, killSequence);
        }
    }

    private void executeKill(Process p, String logKillSequence) throws Exception {
        this.log.info("Issuing kill sequence (on " + System.getProperty("os.name") + "): " + logKillSequence);
        p.waitFor();
        if (p.exitValue() != 0) {
            throw new RuntimeException("Kill sequence failed => server not killed. (Exit value of killing process: " + p.exitValue() + " OS=" + System.getProperty("os.name") + ")");
        }
        Thread.sleep(1000L);
        this.log.info("Kill sequence successfully completed. \n");
    }

    private String getPidForKill(InputStream is) throws IOException {
        String line = null;
        String lineForSplit = null;
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        lineForSplit = in.readLine();
        this.log.info("Getting process id from: " + lineForSplit);
        while ((line = in.readLine()) != null) {
            this.log.warning("There is another line here! : " + line);
        }
        in.close();
        if (lineForSplit != null) {
            String[] output = lineForSplit.split("\\s+");
            return output[5];
        }
        throw new RuntimeException("Finding sequence failed => server not killed. (Unexpected problem in reading process InputStream)");
    }
}

