/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.task.servertask;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.server.test.task.servertask.SpotPrice;
import org.infinispan.tasks.ServerTask;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskExecutionMode;

public class PriceTask
implements ServerTask {
    public static final String NAME = "PriceTask";
    public static final String ACTION_PARAM = "action";
    public static final String TICKER_PARAM = "ticker";
    public static final String AVG_PRICE = "avgPrice";
    public static final String TOP_PRICE_ACTION = "topPrice";
    private TaskContext ctx;

    public void setTaskContext(TaskContext ctx) {
        this.ctx = ctx;
    }

    public String getName() {
        return NAME;
    }

    private <E> E getParam(String name) {
        Optional<Object> paramOpt = this.ctx.getParameters().map(m -> m.get(name));
        if (!paramOpt.isPresent()) {
            throw new IllegalArgumentException("Missing 'action' param");
        }
        return (E)paramOpt.get();
    }

    private Predicate<SpotPrice> byTicker(String ticker) {
        return spotPrice -> spotPrice.getTicker().equals(ticker);
    }

    public Object call() throws Exception {
        Cache cache = this.getCache();
        String action = (String)this.getParam(ACTION_PARAM);
        if (action.equals(AVG_PRICE)) {
            String ticker = (String)this.getParam(TICKER_PARAM);
            return cache.values().stream().filter(this.byTicker(ticker)).mapToDouble(SpotPrice::getPriceUSD).average().orElseThrow(() -> new IllegalStateException("Cannot calculate average"));
        }
        if (action.equals(TOP_PRICE_ACTION)) {
            String ticker = (String)this.getParam(TICKER_PARAM);
            return cache.values().stream().filter(this.byTicker(ticker)).sorted(Comparator.comparing(SpotPrice::getPriceUSD)).collect(Collectors.toList());
        }
        throw new IllegalStateException("Invalid or missing 'action' param");
    }

    public TaskExecutionMode getExecutionMode() {
        return TaskExecutionMode.ONE_NODE;
    }

    private <K, V> Cache<K, V> getCache() {
        return (Cache)this.ctx.getCache().get();
    }
}

