/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.task;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.server.test.category.Task;
import org.infinispan.server.test.task.servertask.Greeting;
import org.infinispan.server.test.task.servertask.GreetingServerTask;
import org.infinispan.server.test.task.servertask.JSExecutingServerTask;
import org.infinispan.server.test.task.servertask.LocalExceptionalServerTask;
import org.infinispan.server.test.task.servertask.LocalMapReduceServerTask;
import org.infinispan.server.test.task.servertask.LocalTestServerTask;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.tasks.ServerTask;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Task.class})
public class LocalServerTaskIT {
    @InfinispanResource(value="standalone-customtask")
    RemoteInfinispanServer server;
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @BeforeClass
    public static void before() throws Exception {
        String serverDir = System.getProperty("server1.dist");
        JavaArchive jar = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        jar.addClass(LocalTestServerTask.class);
        jar.addClass(LocalExceptionalServerTask.class);
        jar.addClass(LocalMapReduceServerTask.class);
        jar.addClass(JSExecutingServerTask.class);
        jar.addClass(GreetingServerTask.class);
        jar.addClass(Greeting.class);
        jar.addAsServiceProvider(ServerTask.class, new Class[]{LocalTestServerTask.class, LocalExceptionalServerTask.class, LocalMapReduceServerTask.class, JSExecutingServerTask.class, GreetingServerTask.class});
        jar.addAsResource(new File("/stream_serverTask.js"));
        jar.addAsManifestResource("MANIFEST.MF");
        File f = new File(serverDir, "/standalone/deployments/custom-task.jar");
        ((ZipExporter)jar.as(ZipExporter.class)).exportTo(f, true);
    }

    @AfterClass
    public static void undeploy() {
        File f;
        String serverDir = System.getProperty("server1.dist");
        File jar = new File(serverDir, "/standalone/deployments/custom-task.jar");
        if (jar.exists()) {
            jar.delete();
        }
        if ((f = new File(serverDir, "/standalone/deployments/custom-task.jar.deployed")).exists()) {
            f.delete();
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-customtask")})
    public void shouldModifyCacheInViaTask() throws Exception {
        RemoteCacheManager rcm = ITestUtils.createCacheManager(this.server);
        String value = "value";
        rcm.getCache().put((Object)"taskExecuted", (Object)value);
        rcm.getCache().execute("serverTask8234892", Collections.emptyMap());
        Assert.assertEquals((Object)("modified:" + value), (Object)rcm.getCache().get((Object)"taskExecuted"));
        Assert.assertEquals((Object)("modified:" + value), (Object)rcm.getCache("taskAccessible").get((Object)"taskExecuted"));
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-customtask")})
    public void shouldThrowExceptionInViaTask() throws Exception {
        RemoteCacheManager rcm = ITestUtils.createCacheManager(this.server);
        this.exceptionRule.expect(HotRodClientException.class);
        this.exceptionRule.expectMessage("Intentionally throws an exception.");
        rcm.getCache().execute("localScript_throwingException", Collections.emptyMap());
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-customtask")})
    public void shouldExecuteMapReduceViaTask() throws Exception {
        RemoteCacheManager rcm = ITestUtils.createCacheManager(this.server);
        RemoteCache remoteCache = rcm.getCache();
        remoteCache.put((Object)1, (Object)"word1 word2 word3");
        remoteCache.put((Object)2, (Object)"word1 word2");
        remoteCache.put((Object)3, (Object)"word1");
        Map result = (Map)remoteCache.execute("local_mapreduce_task", Collections.emptyMap());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((long)3L, (long)((Long)result.get("word1")).intValue());
        Assert.assertEquals((long)2L, (long)((Long)result.get("word2")).intValue());
        Assert.assertEquals((long)1L, (long)((Long)result.get("word3")).intValue());
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-customtask")})
    public void shouldExecuteMapReduceViaJavaScriptInTask() throws Exception {
        RemoteCacheManager rcm = ITestUtils.createCacheManager(this.server);
        RemoteCache remoteCache = rcm.getCache();
        remoteCache.put((Object)1, (Object)"word1 word2 word3");
        remoteCache.put((Object)2, (Object)"word1 word2");
        remoteCache.put((Object)3, (Object)"word1");
        Map result = (Map)remoteCache.execute("jsexecutor_task", Collections.emptyMap());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((long)3L, (long)((Long)result.get("word1")).intValue());
        Assert.assertEquals((long)2L, (long)((Long)result.get("word2")).intValue());
        Assert.assertEquals((long)1L, (long)((Long)result.get("word3")).intValue());
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-customtask")})
    public void shouldWorkWithCustomMojo() throws Exception {
        RemoteCacheManager rcm = ITestUtils.createCacheManager(this.server);
        RemoteCache remoteCache = rcm.getCache();
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("greeting", this.toBytes(new Greeting("hello, good morning :)")));
        String result = (String)remoteCache.execute("testTask", params);
        Assert.assertEquals((Object)"hello, good morning :)", (Object)result);
    }

    private byte[] toBytes(Object o) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(o);
            oos.close();
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

