/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.task;

import java.io.File;
import java.util.Collections;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.server.test.category.Security;
import org.infinispan.server.test.category.Task;
import org.infinispan.server.test.task.servertask.LocalAuthTestServerTask;
import org.infinispan.server.test.util.security.SecurityConfigurationHelper;
import org.infinispan.tasks.ServerTask;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Task.class, Security.class})
@WithRunningServer(value={@RunningServer(name="hotrodAuth")})
public class LocalAuthServerTaskIT {
    @InfinispanResource(value="hotrodAuth")
    RemoteInfinispanServer server;
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @BeforeClass
    public static void before() throws Exception {
        String serverDir = System.getProperty("server1.dist");
        JavaArchive jar = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        jar.addClass(LocalAuthTestServerTask.class);
        jar.addAsServiceProvider(ServerTask.class, new Class[]{LocalAuthTestServerTask.class});
        File f = new File(serverDir, "/standalone/deployments/custom-task-auth.jar");
        ((ZipExporter)jar.as(ZipExporter.class)).exportTo(f, true);
    }

    @AfterClass
    public static void undeploy() {
        File f;
        String serverDir = System.getProperty("server1.dist");
        File jar = new File(serverDir, "/standalone/deployments/custom-task-auth.jar");
        if (jar.exists()) {
            jar.delete();
        }
        if ((f = new File(serverDir, "/standalone/deployments/custom-task-auth.jar.deployed")).exists()) {
            f.delete();
        }
    }

    @Test
    public void shouldPassWithAuth() throws Exception {
        SecurityConfigurationHelper config = new SecurityConfigurationHelper("DIGEST-MD5");
        config.forIspnServer(this.server).withServerName("node0");
        config.forCredentials("executor", "executorPassword");
        RemoteCacheManager rcm = new RemoteCacheManager(config.build(), true);
        RemoteCache remoteCache = rcm.getCache("customTaskCache");
        String result = (String)remoteCache.execute("localAuthTest", Collections.emptyMap());
        Assert.assertEquals((Object)"executed", (Object)result);
        Assert.assertEquals((Object)true, (Object)remoteCache.get((Object)"actionPerformed"));
    }

    @Test
    public void shouldThrowException() throws Exception {
        SecurityConfigurationHelper config = new SecurityConfigurationHelper("DIGEST-MD5");
        config.forIspnServer(this.server).withServerName("node0");
        config.forCredentials("admin", "strongPassword");
        RemoteCacheManager rcm = new RemoteCacheManager(config.build(), true);
        RemoteCache remoteCache = rcm.getCache("customTaskCache");
        this.exceptionRule.expect(HotRodClientException.class);
        this.exceptionRule.expectMessage("lacks 'EXEC' permission");
        remoteCache.execute("localAuthTest", Collections.emptyMap());
    }
}

