/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.server.test.category.Task;
import org.infinispan.server.test.task.AbstractDistributedServerTaskIT;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Task.class})
@WithRunningServer(value={@RunningServer(name="clusteredcache-1"), @RunningServer(name="clusteredcache-2")})
public class DistributedServerTaskIT
extends AbstractDistributedServerTaskIT {
    @InfinispanResource(value="clusteredcache-1")
    RemoteInfinispanServer server1;
    @InfinispanResource(value="clusteredcache-2")
    RemoteInfinispanServer server2;

    @Override
    protected List<RemoteInfinispanServer> getServers() {
        ArrayList<RemoteInfinispanServer> servers = new ArrayList<RemoteInfinispanServer>();
        servers.add(this.server1);
        servers.add(this.server2);
        return Collections.unmodifiableList(servers);
    }

    @BeforeClass
    public static void before() throws Exception {
        String[] serverDirs = new String[]{System.getProperty("server1.dist"), System.getProperty("server2.dist")};
        JavaArchive jar = DistributedServerTaskIT.createJavaArchive();
        jar.addAsResource(new File("/stream_serverTask.js"));
        jar.addAsManifestResource("MANIFEST.MF");
        for (String serverDir : serverDirs) {
            File f = new File(serverDir, "/standalone/deployments/custom-distributed-task.jar");
            ((ZipExporter)jar.as(ZipExporter.class)).exportTo(f, true);
        }
        expectedServerList = Arrays.asList("node0", "node1");
    }

    @AfterClass
    public static void undeploy() {
        String[] serverDirs;
        for (String serverDir : serverDirs = new String[]{System.getProperty("server1.dist"), System.getProperty("server2.dist")}) {
            File f;
            File jar = new File(serverDir, "/standalone/deployments/custom-distributed-task.jar");
            if (jar.exists()) {
                jar.delete();
            }
            if (!(f = new File(serverDir, "/standalone/deployments/custom-distributed-task.jar.deployed")).exists()) continue;
            f.delete();
        }
    }
}

