/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.task;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.server.test.category.Task;
import org.infinispan.server.test.task.servertask.DistributedDeploymentTestServerTask;
import org.infinispan.tasks.ServerTask;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Task.class})
@WithRunningServer(value={@RunningServer(name="clusteredcache-1"), @RunningServer(name="clusteredcache-2")})
public class DistributedServerTaskDeploymentIT {
    @InfinispanResource(value="clusteredcache-1")
    RemoteInfinispanServer server1;
    @InfinispanResource(value="clusteredcache-2")
    RemoteInfinispanServer server2;
    @ArquillianResource
    private Deployer deployer;
    RemoteCacheManager rcm1;
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @Deployment(name="node1", managed=false)
    @TargetsContainer(value="clusteredcache-1")
    @OverProtocol(value="jmx-as7")
    public static JavaArchive create1() {
        JavaArchive jar = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"custom-task-deployment.jar");
        jar.addClass(DistributedDeploymentTestServerTask.class);
        jar.addAsServiceProvider(ServerTask.class, new Class[]{DistributedDeploymentTestServerTask.class});
        return jar;
    }

    @Deployment(name="node2", managed=false)
    @TargetsContainer(value="clusteredcache-2")
    @OverProtocol(value="jmx-as7")
    public static JavaArchive create2() {
        JavaArchive jar = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"custom-task-deployment.jar");
        jar.addClass(DistributedDeploymentTestServerTask.class);
        jar.addAsServiceProvider(ServerTask.class, new Class[]{DistributedDeploymentTestServerTask.class});
        return jar;
    }

    @Before
    public void setUp() {
        if (this.rcm1 == null) {
            Configuration conf = new ConfigurationBuilder().addServer().host(this.server1.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server1.getHotrodEndpoint().getPort()).build();
            this.rcm1 = new RemoteCacheManager(conf);
        }
    }

    @Test
    @InSequence(value=1)
    public void testDeploy() {
        this.deployer.deploy("node1");
        this.deployer.deploy("node2");
    }

    @Test
    @InSequence(value=2)
    public void shouldGatherNodeNamesInRemoteTasks() throws Exception {
        Object resultObject = this.rcm1.getCache().execute("server_task_deployment_test", Collections.emptyMap());
        Assert.assertNotNull((Object)resultObject);
        List result = (List)resultObject;
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((String)"result list does not contain expected items.", (boolean)result.containsAll(Arrays.asList("node0", "node1")));
    }

    @Test
    @InSequence(value=3)
    public void testTaskUndeploy() {
        this.deployer.undeploy("node1");
        this.deployer.undeploy("node2");
        this.exceptionRule.expect(HotRodClientException.class);
        this.exceptionRule.expectMessage("ISPN027002");
        this.rcm1.getCache().execute("server_task_deployment_test", Collections.emptyMap());
    }
}

