/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.task;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.server.test.category.Task;
import org.infinispan.server.test.task.servertask.DistributedAuthServerTask;
import org.infinispan.server.test.task.servertask.LocalAuthTestServerTask;
import org.infinispan.server.test.util.security.SecurityConfigurationHelper;
import org.infinispan.tasks.ServerTask;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Task.class})
@WithRunningServer(value={@RunningServer(name="hotrodAuthClustered"), @RunningServer(name="hotrodAuthClustered-2")})
public class DistributedAuthServerTaskIT {
    @InfinispanResource(value="hotrodAuthClustered")
    RemoteInfinispanServer server1;
    @InfinispanResource(value="hotrodAuthClustered-2")
    RemoteInfinispanServer server2;
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @BeforeClass
    public static void before() throws Exception {
        String[] serverDirs = new String[]{System.getProperty("server1.dist"), System.getProperty("server2.dist")};
        JavaArchive jar = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        jar.addClass(DistributedAuthServerTask.class);
        jar.addClass(LocalAuthTestServerTask.class);
        jar.addAsServiceProvider(ServerTask.class, new Class[]{DistributedAuthServerTask.class, LocalAuthTestServerTask.class});
        for (String serverDir : serverDirs) {
            File f = new File(serverDir, "/standalone/deployments/custom-distributed-task-with-auth.jar");
            ((ZipExporter)jar.as(ZipExporter.class)).exportTo(f, true);
        }
    }

    @AfterClass
    public static void undeploy() {
        File f;
        String serverDir = System.getProperty("server1.dist");
        File jar = new File(serverDir, "/standalone/deployments/custom-distributed-task-with-auth.jar");
        if (jar.exists()) {
            jar.delete();
        }
        if ((f = new File(serverDir, "/standalone/deployments/custom-distributed-task-with-auth.jar.deployed")).exists()) {
            f.delete();
        }
    }

    @Test
    public void shouldRunLocalAuthTest() throws Exception {
        SecurityConfigurationHelper config = new SecurityConfigurationHelper("DIGEST-MD5");
        config.forIspnServer(this.server1).withServerName("node0");
        config.forCredentials("executor", "executorPassword");
        RemoteCacheManager rcm = new RemoteCacheManager(config.build(), true);
        RemoteCache remoteCache = rcm.getCache("customTaskCache");
        String result = (String)remoteCache.execute("localAuthTest", Collections.emptyMap());
        Assert.assertEquals((Object)"executed", (Object)result);
        Assert.assertEquals((Object)true, (Object)remoteCache.get((Object)"actionPerformed"));
        rcm.stop();
    }

    @Test
    public void shouldRunDistAuthTest() throws Exception {
        SecurityConfigurationHelper config = new SecurityConfigurationHelper("DIGEST-MD5");
        config.forIspnServer(this.server1).withServerName("node0");
        config.forCredentials("executor", "executorPassword");
        RemoteCacheManager rcm = new RemoteCacheManager(config.build(), true);
        RemoteCache remoteCache = rcm.getCache("customTaskCache");
        List result = (List)remoteCache.execute("serverTask_distributed_authentication", Collections.emptyMap());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((String)"result list does not contain expected items.", (boolean)result.containsAll(Arrays.asList("node0", "node1")));
        rcm.stop();
    }

    @Test
    public void shouldThrowException() throws Exception {
        SecurityConfigurationHelper config = new SecurityConfigurationHelper("DIGEST-MD5");
        config.forIspnServer(this.server1).withServerName("node0");
        config.forCredentials("admin", "strongPassword");
        RemoteCacheManager rcm = new RemoteCacheManager(config.build(), true);
        RemoteCache remoteCache = rcm.getCache("customTaskCache");
        this.exceptionRule.expect(HotRodClientException.class);
        this.exceptionRule.expectMessage("lacks 'EXEC' permission");
        remoteCache.execute("serverTask_distributed_authentication", Collections.emptyMap());
        rcm.stop();
    }
}

