/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.server.test.task.servertask.DistributedCacheUsingTask;
import org.infinispan.server.test.task.servertask.DistributedJSExecutingServerTask;
import org.infinispan.server.test.task.servertask.DistributedMapReduceServerTask;
import org.infinispan.server.test.task.servertask.DistributedTestServerTask;
import org.infinispan.server.test.task.servertask.JSExecutingServerTask;
import org.infinispan.server.test.task.servertask.LocalMapReduceServerTask;
import org.infinispan.tasks.ServerTask;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public abstract class AbstractDistributedServerTaskIT {
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();
    private static List<RemoteCacheManager> managers = null;
    protected static List<String> expectedServerList;
    protected static final String CACHE_NAME = "customTaskRepl";
    protected static final String CACHE_NAME_TX = "customTaskReplTx";

    protected abstract List<RemoteInfinispanServer> getServers();

    @Before
    public void setUp() {
        if (managers == null) {
            managers = new ArrayList<RemoteCacheManager>();
            for (RemoteInfinispanServer server : this.getServers()) {
                Configuration conf = new ConfigurationBuilder().addServer().host(server.getHotrodEndpoint().getInetAddress().getHostName()).port(server.getHotrodEndpoint().getPort()).build();
                managers.add(new RemoteCacheManager(conf, true));
            }
        }
        for (RemoteCacheManager rcm : managers) {
            rcm.getCache().clear();
            rcm.getCache(CACHE_NAME).clear();
            rcm.getCache(CACHE_NAME_TX).clear();
        }
    }

    @AfterClass
    public static void release() {
        if (managers != null && !managers.isEmpty()) {
            for (RemoteCacheManager manager : managers) {
                manager.stop();
            }
        }
    }

    protected static JavaArchive createJavaArchive() {
        JavaArchive jar = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        jar.addClass(DistributedTestServerTask.class);
        jar.addClass(DistributedCacheUsingTask.class);
        jar.addClass(DistributedMapReduceServerTask.class);
        jar.addClass(DistributedJSExecutingServerTask.class);
        jar.addClass(LocalMapReduceServerTask.class);
        jar.addClass(JSExecutingServerTask.class);
        jar.addAsServiceProvider(ServerTask.class, new Class[]{DistributedTestServerTask.class, DistributedCacheUsingTask.class, DistributedMapReduceServerTask.class, DistributedJSExecutingServerTask.class});
        return jar;
    }

    @Test
    public void shouldGatherNodeNamesInRemoteTasks() throws Exception {
        Object resultObject = managers.get(0).getCache().execute("serverTask777792", Collections.emptyMap());
        Assert.assertNotNull((Object)resultObject);
        List result = (List)resultObject;
        Assert.assertEquals((long)2L, (long)result.size());
        System.out.println("The RESULT IS: " + result);
        Assert.assertTrue((String)"result list does not contain expected items.", (boolean)result.containsAll(expectedServerList));
    }

    @Test
    public void shouldThrowExceptionInRemoteTasks() throws Exception {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("throwException", true);
        this.exceptionRule.expect(HotRodClientException.class);
        this.exceptionRule.expectMessage("Intentionally Thrown Exception");
        managers.get(0).getCache().execute("serverTask777792", params);
    }

    @Test
    public void shouldPutNewValueInRemoteCache() throws Exception {
        String key = "key";
        String value = "value";
        String paramValue = "parameter";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("param", paramValue);
        managers.get(1).getCache(CACHE_NAME_TX);
        managers.get(0).getCache(CACHE_NAME_TX).put((Object)key, (Object)value);
        managers.get(0).getCache(CACHE_NAME_TX).execute("serverTask_distributed_cacheUsage", params);
        Assert.assertEquals((Object)"modified:modified:value:parameter:parameter", (Object)managers.get(0).getCache(CACHE_NAME_TX).get((Object)key));
    }

    @Test
    public void shouldExecuteMapReduceOnReplCacheViaTask() throws Exception {
        RemoteCache remoteCache = managers.get(1).getCache(CACHE_NAME);
        remoteCache.put((Object)1, (Object)"word1 word2 word3");
        remoteCache.put((Object)2, (Object)"word1 word2");
        remoteCache.put((Object)3, (Object)"word1");
        List result = (List)remoteCache.execute("dist_mapreduce_task", Collections.emptyMap());
        Assert.assertEquals((long)2L, (long)result.size());
        this.verifyMapReduceResult((Map)result.get(0));
        this.verifyMapReduceResult((Map)result.get(1));
    }

    @Test
    @Ignore(value="Is disabled until ISPN-6173 is fixed.")
    public void shouldExecuteMapReduceViaJavaScriptInTask() throws Exception {
        RemoteCache remoteCache = managers.get(1).getCache(CACHE_NAME);
        remoteCache.put((Object)1, (Object)"word1 word2 word3");
        remoteCache.put((Object)2, (Object)"word1 word2");
        remoteCache.put((Object)3, (Object)"word1");
        List result = (List)remoteCache.execute("dist_jsexecutor_task", Collections.emptyMap());
        Assert.assertEquals((long)2L, (long)result.size());
        this.verifyMapReduceResult((Map)result.get(0));
        this.verifyMapReduceResult((Map)result.get(1));
    }

    private void verifyMapReduceResult(Map<String, Long> result) {
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((long)3L, (long)result.get("word1").intValue());
        Assert.assertEquals((long)2L, (long)result.get("word2").intValue());
        Assert.assertEquals((long)1L, (long)result.get("word3").intValue());
    }
}

