/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.security.jgroups.encrypt;

import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServers;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.server.test.category.Security;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Security.class})
public class EncryptProtocolIT {
    @InfinispanResource
    RemoteInfinispanServers servers;
    @ArquillianResource
    ContainerController controller;
    final String COORDINATOR_NODE = "clustered-encrypt-1";
    final String JOINING_NODE = "clustered-encrypt-2";
    final String ENCRYPT_MBEAN = "jgroups:type=protocol,cluster=\"cluster\",protocol=SYM_ENCRYPT";
    final String ENCRYPT_PROPERTY_KEY = "keystore_name";
    final String ENCRYPT_PROPERTY_VALUE_SUFFIX = "cluster.jks";
    final String ENCRYPT_PASSWORD_KEY = "store_password";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @WithRunningServer(value={@RunningServer(name="clustered-encrypt-1")})
    public void testEncryptProtocolRegistered() throws Exception {
        try {
            this.controller.start("clustered-encrypt-2");
            RemoteInfinispanMBeans coordinator = RemoteInfinispanMBeans.create(this.servers, "clustered-encrypt-1", "memcachedCache", "clustered");
            RemoteInfinispanMBeans friend = RemoteInfinispanMBeans.create(this.servers, "clustered-encrypt-2", "memcachedCache", "clustered");
            MBeanServerConnectionProvider providerCoordinator = new MBeanServerConnectionProvider(coordinator.server.getHotrodEndpoint().getInetAddress().getHostName(), 9990);
            MBeanServerConnectionProvider providerFriend = new MBeanServerConnectionProvider(friend.server.getHotrodEndpoint().getInetAddress().getHostName(), 10090);
            MemcachedClient mcCoordinator = new MemcachedClient(coordinator.server.getMemcachedEndpoint().getInetAddress().getHostName(), coordinator.server.getMemcachedEndpoint().getPort());
            MemcachedClient mcFriend = new MemcachedClient(friend.server.getMemcachedEndpoint().getInetAddress().getHostName(), friend.server.getMemcachedEndpoint().getPort());
            Assert.assertEquals((long)2L, (long)coordinator.manager.getClusterSize());
            Assert.assertEquals((long)2L, (long)friend.manager.getClusterSize());
            Assert.assertTrue((boolean)ITestUtils.getAttribute(providerCoordinator, "jgroups:type=protocol,cluster=\"cluster\",protocol=SYM_ENCRYPT", "keystore_name").endsWith("cluster.jks"));
            Assert.assertTrue((boolean)ITestUtils.getAttribute(providerFriend, "jgroups:type=protocol,cluster=\"cluster\",protocol=SYM_ENCRYPT", "keystore_name").endsWith("cluster.jks"));
            Assert.assertNull((Object)ITestUtils.getAttribute(providerCoordinator, "jgroups:type=protocol,cluster=\"cluster\",protocol=SYM_ENCRYPT", "store_password"));
            mcFriend.set("key1", "value1");
            Assert.assertEquals((String)"Could not read replicated pair key1/value1", (Object)"value1", (Object)mcCoordinator.get("key1"));
        }
        finally {
            this.controller.stop("clustered-encrypt-2");
        }
    }
}

