/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.security.cache;

import java.security.PrivilegedActionException;
import javax.security.auth.login.LoginException;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.server.test.category.Security;
import org.infinispan.server.test.client.hotrod.security.HotRodAuthzOperationTests;
import org.infinispan.server.test.util.security.SecurityConfigurationHelper;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Security.class})
@WithRunningServer(value={@RunningServer(name="hotrodAuthExternalClustered-2")})
public class ClusteredCacheAuthExternalIT {
    private static final String SASL_MECH = "EXTERNAL";
    private static final String ARQ_NODE_1_ID = "hotrodAuthExternalClustered";
    @ArquillianResource
    public ContainerController controller;
    @InfinispanResource(value="hotrodAuthExternalClustered")
    RemoteInfinispanServer server1;
    @InfinispanResource(value="hotrodAuthExternalClustered-2")
    RemoteInfinispanServer server2;
    private static RemoteCacheManager rcm;
    private static boolean isInitialized;

    public void initRCM() {
        this.controller.start(ARQ_NODE_1_ID);
        SecurityConfigurationHelper cb = new SecurityConfigurationHelper(SASL_MECH).forIspnServer(this.server1).withServerName("node0").withDefaultSsl();
        cb.security().ssl().keyAlias("client1");
        rcm = new RemoteCacheManager(cb.forExternalAuth().build(), true);
        this.controller.stop(ARQ_NODE_1_ID);
        isInitialized = true;
    }

    @AfterClass
    public static void release() {
        if (rcm != null) {
            rcm.stop();
        }
    }

    private synchronized RemoteCache<String, String> getRemoteCacheFor(String login) {
        if (!isInitialized) {
            this.initRCM();
        }
        return rcm.getCache("testcache");
    }

    @Test
    public void testReaderRead() throws PrivilegedActionException, LoginException {
        RemoteCache<String, String> cache = this.getRemoteCacheFor("reader");
        HotRodAuthzOperationTests.testGetNonExistent(cache);
    }

    @Test(expected=HotRodClientException.class)
    public void testReaderWrite() throws PrivilegedActionException, LoginException {
        RemoteCache<String, String> cache = this.getRemoteCacheFor("reader");
        HotRodAuthzOperationTests.testPut(cache);
    }

    static {
        isInitialized = false;
    }
}

