/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.rollingupgrades;

import javax.management.ObjectName;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServers;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.server.test.category.RollingUpgrades;
import org.infinispan.server.test.client.rest.RESTHelper;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@Ignore(value="Disabled until ISPN-7617 is fixed")
@RunWith(value=Arquillian.class)
@Category(value={RollingUpgrades.class})
public class RestRollingUpgradesIT {
    @InfinispanResource
    RemoteInfinispanServers serverManager;
    static final String DEFAULT_CACHE_NAME = "default";
    static final int PORT_OFFSET = 100;
    @ArquillianResource
    ContainerController controller;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestRollingUpgradesDiffVersions() throws Exception {
        int managementPortServer1 = 9990;
        RESTHelper rest = new RESTHelper();
        try {
            if (!Boolean.parseBoolean(System.getProperty("start.jboss.as.manually"))) {
                this.controller.start("rest-rolling-upgrade-2-old");
            }
            rest.addServer("127.0.0.1", "/rest");
            rest.post(rest.fullPathKey(0, DEFAULT_CACHE_NAME, "key1", 100), "data", "text/html");
            rest.get(rest.fullPathKey(0, DEFAULT_CACHE_NAME, "key1", 100), "data");
            for (int i = 0; i < 50; ++i) {
                rest.post(rest.fullPathKey(0, DEFAULT_CACHE_NAME, "keyLoad" + i, 100), "valueLoad" + i, "text/html");
            }
            this.controller.start("rest-rolling-upgrade-1");
            RemoteInfinispanMBeans s1 = this.createRemotes("rest-rolling-upgrade-1", "local", DEFAULT_CACHE_NAME);
            rest.addServer(s1.server.getRESTEndpoint().getInetAddress().getHostName(), s1.server.getRESTEndpoint().getContextPath());
            rest.get(rest.fullPathKey(1, DEFAULT_CACHE_NAME, "key1", 0), "data");
            MBeanServerConnectionProvider provider1 = new MBeanServerConnectionProvider(s1.server.getRESTEndpoint().getInetAddress().getHostName(), 9990);
            ObjectName rollMan = new ObjectName("jboss.datagrid-infinispan:type=Cache,name=\"default(local)\",manager=\"local\",component=RollingUpgradeManager");
            this.invokeOperation(provider1, rollMan.toString(), "synchronizeData", new Object[]{"rest"}, new String[]{"java.lang.String"});
            this.invokeOperation(provider1, rollMan.toString(), "disconnectSource", new Object[]{"rest"}, new String[]{"java.lang.String"});
            rest.post(rest.fullPathKey(0, DEFAULT_CACHE_NAME, "disconnected", 100), "source", "text/plain");
            rest.get(rest.fullPathKey(1, DEFAULT_CACHE_NAME, "disconnected", 0), 404);
            for (int i = 0; i < 50; ++i) {
                rest.get(rest.fullPathKey(1, DEFAULT_CACHE_NAME, "keyLoad" + i, 0), "valueLoad" + i);
            }
        }
        finally {
            if (this.controller.isStarted("rest-rolling-upgrade-1")) {
                this.controller.stop("rest-rolling-upgrade-1");
            }
            if (this.controller.isStarted("rest-rolling-upgrade-2-old")) {
                this.controller.stop("rest-rolling-upgrade-2-old");
            }
        }
    }

    protected RemoteInfinispanMBeans createRemotes(String serverName, String managerName, String cacheName) {
        return RemoteInfinispanMBeans.create(this.serverManager, serverName, cacheName, managerName);
    }

    private Object invokeOperation(MBeanServerConnectionProvider provider, String mbean, String operationName, Object[] params, String[] signature) throws Exception {
        return provider.getConnection().invoke(new ObjectName(mbean), operationName, params, signature);
    }
}

